/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.impl.trace.AllocationTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.DumpClassStatisticTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.GcHistoryFileDumpTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.GcTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.HprofDumpTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.IOTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.MethodParameterTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.NetworkTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.PerformanceHotspotTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.SynchronizationTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ThreadDumpTraceImpl;
import com.sap.jvm.profiling.controller.trace.ProfilingTrace;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public abstract class ProfilingTraceImpl
implements ProfilingTrace {
    private static final short TAG = -1;
    protected final String name;
    protected ProfilingTraceState state;
    protected Bookmark startBookmark;
    protected Bookmark endBookmark;
    protected long startTimestamp;
    protected long endTimestamp;
    protected ProfilingSession session;

    public static ProfilingTraceImpl read(ResourceReader reader) throws IOException {
        short typeIndex = reader.readInt16();
        ProfilingTraceType type = ProfilingTraceType.get((int)typeIndex);
        switch (type) {
            case ALLOCATION_TRACE: {
                return AllocationTraceImpl.read(reader);
            }
            case PERFORMANCE_HOTSPOT_TRACE: {
                return PerformanceHotspotTraceImpl.read(reader);
            }
            case METHOD_PARAMETER_TRACE: {
                return MethodParameterTraceImpl.read(reader);
            }
            case IO_TRACE: {
                return IOTraceImpl.read(reader);
            }
            case SYNCHRONIZATION_TRACE: {
                return SynchronizationTraceImpl.read(reader);
            }
            case NETWORK_TRACE: {
                return NetworkTraceImpl.read(reader);
            }
            case HPROF_DUMP: {
                return HprofDumpTraceImpl.read(reader);
            }
            case GC_TRACE: {
                return GcTraceImpl.read(reader);
            }
            case CLASS_STATISTIC_TRACE: {
                return DumpClassStatisticTraceImpl.read(reader);
            }
            case THREAD_DUMP_TRACE: {
                return ThreadDumpTraceImpl.read(reader);
            }
            case GC_HISTORY_FILE_DUMP: {
                return GcHistoryFileDumpTraceImpl.read(reader);
            }
            case ALL_TRACES: {
                break;
            }
            case METHOD_TRACE: {
                break;
            }
            case THREAD_HOTSPOT_TRACE: {
                break;
            }
        }
        assert (false);
        return null;
    }

    public ProfilingTraceImpl(String name, ProfilingSession session) {
        assert (name != null);
        this.name = name;
        this.state = ProfilingTraceState.DISABLED;
        this.session = session;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ProfilingTraceState getState() {
        return this.state;
    }

    public void setTraceState(ProfilingTraceState newState) {
        this.state = newState;
    }

    @Override
    public Bookmark getStartBookmark() {
        return this.startBookmark;
    }

    @Override
    public Bookmark getEndBookmark() {
        return this.endBookmark;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setStartBookmark(Bookmark start) {
        this.startBookmark = start;
    }

    public void setEndBookmark(Bookmark end) {
        this.endBookmark = end;
    }

    public void setStartTimeStamp(long timestamp) {
        this.startTimestamp = timestamp;
    }

    public void setEndTimeStamp(long timestamp) {
        this.endTimestamp = timestamp;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt16((short)this.getType().getIndex());
        this.startBookmark.write(writer);
        boolean endBookmarkAvail = this.endBookmark != null;
        writer.writeBoolean(endBookmarkAvail);
        if (endBookmarkAvail) {
            this.endBookmark.write(writer);
        }
        writer.writeInt64(this.startTimestamp);
        if (this.endTimestamp == 0L) {
            writer.writeInt64(this.session.getLastlyReadTimestamp());
        } else {
            writer.writeInt64(this.endTimestamp);
        }
        boolean enabled = this.state == ProfilingTraceState.ENABLED;
        writer.writeBoolean(enabled);
        writer.writeString(this.name);
    }

    protected static int readVersion(ResourceReader reader, int min, int max) throws IOException {
        short type;
        if (reader.hasNext(2) && (type = reader.peekInt16()) == -1) {
            reader.readInt16();
            return reader.readVersion(min, max);
        }
        return -1;
    }

    protected static void writeVersion(ResourceWriter writer, int version) throws IOException {
        writer.writeInt16((short)-1);
        writer.writeVersion(version);
    }
}

