/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.ProfilingTrace;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSet;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ProfilingTraceSetImpl
implements ProfilingTraceSet {
    private ArrayList<ProfilingTraceImpl> traceSet = new ArrayList();

    public static ProfilingTraceSetImpl read(ResourceReader reader) throws IOException {
        ProfilingTraceSetImpl retValue = new ProfilingTraceSetImpl();
        int nrTraces = reader.readInt32();
        for (int i = 0; i < nrTraces; ++i) {
            ProfilingTraceImpl trace = ProfilingTraceImpl.read(reader);
            retValue.add(trace);
        }
        return retValue;
    }

    @Override
    public int size() {
        return this.traceSet.size();
    }

    @Override
    public boolean contains(ProfilingTrace trace) {
        return this.traceSet.contains(trace);
    }

    public ProfilingTraceImpl[] get() {
        ProfilingTraceImpl[] retValue = new ProfilingTraceImpl[this.traceSet.size()];
        this.traceSet.toArray(retValue);
        return retValue;
    }

    @Override
    public ProfilingTraceImpl get(int index) {
        return this.traceSet.get(index);
    }

    public void add(ProfilingTraceImpl trace) {
        this.traceSet.add(trace);
    }

    public ProfilingTraceImpl setState(ProfilingTraceType type, ProfilingTraceState state) {
        for (ProfilingTraceImpl trace : this.traceSet) {
            if (trace.getType() != type) continue;
            trace.setTraceState(state);
            return trace;
        }
        return null;
    }

    public void remove(ProfilingTraceType type) {
        ProfilingTraceImpl traceToRemove = null;
        for (ProfilingTraceImpl trace : this.traceSet) {
            if (trace.getType() != type) continue;
            traceToRemove = trace;
            break;
        }
        this.traceSet.remove(traceToRemove);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.traceSet.size());
        for (int i = 0; i < this.traceSet.size(); ++i) {
            ProfilingTraceImpl trace = this.traceSet.get(i);
            trace.write(writer);
        }
    }

    @Override
    public boolean contains(ProfilingTraceType traceType) {
        for (ProfilingTraceImpl trace : this.traceSet) {
            if (trace.getType() != traceType) continue;
            return true;
        }
        return false;
    }
}

