/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.controller.trace.SynchronizationTrace;
import com.sap.jvm.profiling.controller.trace.SynchronizationTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.sync.command.DisableSynchronizationTraceCommand;
import com.sap.jvm.profiling.sync.command.EnableSynchronizationTraceCommand;
import com.sap.jvm.profiling.sync.command.SynchronizationTraceConfiguration;
import java.io.IOException;

public final class SynchronizationTraceImpl
extends ProfilingTraceImpl
implements SynchronizationTrace {
    private SynchronizationTraceSpec spec;
    private long nrOfBlockedEvents;
    private long blockedTime;
    private long nrOfWaitEvents;

    public static SynchronizationTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        long nrOfBlockedEvents = reader.readInt64();
        long nrOfWaitEvents = reader.readInt64();
        long blockedTimeNS = reader.readInt64();
        String threadFilterString = reader.readString();
        SynchronizationTraceSpec spec = new SynchronizationTraceSpec();
        if (ProfilingTraceSpec.isFiltering(threadFilterString)) {
            spec.setThreadFilter(new ThreadFilter(threadFilterString));
        }
        SynchronizationTraceImpl retValue = new SynchronizationTraceImpl(name, spec, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setNrOfBlockedEvents(nrOfBlockedEvents);
        retValue.setBlockedTime(blockedTimeNS);
        retValue.setNrOfWaitEvents(nrOfWaitEvents);
        retValue.setTraceState(state);
        return retValue;
    }

    public SynchronizationTraceImpl(String name, SynchronizationTraceSpec spec, ProfilingSession session) {
        super(name, session);
        this.spec = spec;
    }

    @Override
    public SynchronizationTraceSpec getSpecification() {
        return this.spec;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.SYNCHRONIZATION_TRACE;
    }

    @Override
    public long getNrOfBlockedEvents() {
        return this.nrOfBlockedEvents;
    }

    @Override
    public long getBlockedTime() {
        return this.blockedTime;
    }

    @Override
    public long getNrOfWaitEvents() {
        return this.nrOfWaitEvents;
    }

    public void setNrOfBlockedEvents(long nrOfBlockedEvents) {
        this.nrOfBlockedEvents = nrOfBlockedEvents;
    }

    public void setBlockedTime(long blockedTime) {
        this.blockedTime = blockedTime;
    }

    public void setNrOfWaitEvents(long nrOfWaitEvents) {
        this.nrOfWaitEvents = nrOfWaitEvents;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfBlockedEvents);
        writer.writeInt64(this.nrOfWaitEvents);
        writer.writeInt64(this.blockedTime);
        writer.writeString(this.spec.getThreadFilter() == null ? "**" : this.spec.getThreadFilter().asString());
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        SynchronizationTraceConfiguration config = new SynchronizationTraceConfiguration();
        config.setThreadFilter(this.spec.getThreadFilter());
        config.setWaitNotifyEnabled(false);
        EnableSynchronizationTraceCommand cmd = provider.getSynchronizationFactory().createEnableSynchronizationTraceCommand(config);
        return handler.sendCommand((Command)cmd, true);
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        DisableSynchronizationTraceCommand cmd = provider.getSynchronizationFactory().createDisableSynchronizationTraceCommand();
        return handler.sendCommand((Command)cmd, true);
    }
}

