/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.controller.trace.ThreadDumpTrace;
import com.sap.jvm.profiling.controller.trace.ThreadDumpTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.thread.command.ThreadDumpConfiguration;
import java.io.IOException;

public class ThreadDumpTraceImpl
extends ProfilingTraceImpl
implements ThreadDumpTrace {
    private static int VERSION = 0;
    private ThreadDumpTraceSpec spec;
    private int numThreadDumps;
    private int quality;
    private long duration;

    public static ThreadDumpTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        reader.readVersion(VERSION);
        int numThreadDumps = reader.readInt32();
        int quality = reader.readInt32();
        ThreadDumpConfiguration config = ThreadDumpConfiguration.read((ResourceReader)reader);
        ThreadDumpTraceSpec spec = new ThreadDumpTraceSpec(config);
        ThreadDumpTraceImpl retValue = new ThreadDumpTraceImpl(name, spec, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setTraceState(state);
        retValue.setNumberThreadDumps(numThreadDumps);
        retValue.setQuality(quality);
        return retValue;
    }

    public ThreadDumpTraceImpl(String name, ThreadDumpTraceSpec spec, ProfilingSession session) {
        super(name, session);
        this.spec = spec;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.THREAD_DUMP_TRACE;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(VERSION);
        writer.writeInt32(this.numThreadDumps);
        writer.writeInt32(this.quality);
        this.spec.getConfiguration().write(writer);
    }

    @Override
    public ThreadDumpTraceSpec getSpecification() {
        return this.spec;
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        return handler.sendCommand((Command)provider.getThreadFactory().createEnableThreadDumpsCommand(this.spec.getConfiguration()), true);
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        return handler.sendCommand((Command)provider.getThreadFactory().createDisableThreadDumpsCommand(), true);
    }

    @Override
    public int getNumberThreadDumps() {
        return this.numThreadDumps;
    }

    public void setNumberThreadDumps(int numThreadDumps) {
        this.numThreadDumps = numThreadDumps;
    }

    @Override
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }
}

