/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.model;

import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.controller.model.HeartBeatListener;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.event.HeartBeatGCStatistic;
import java.util.List;

public interface HeartBeatInfo
extends SessionAssociated {
    public boolean isDataReceived();

    public void reset();

    public int getReceivedPacketCount();

    public long getHeapSize();

    public double getMaxCPULoad();

    public double getMinCPULoad();

    public double getAvgCPULoad();

    public long getMaxMemUsage();

    public long getMinMemUsage();

    public long getAvgMemUsage();

    public int getGcCount();

    public long getAvgGcDuration();

    public long getStartTimeMillis();

    public long getEndTimeMillis();

    public List<TraceLifeRange> getTraceLifeCycle(ProfilingTraceType var1);

    public void addHeartBeatListener(HeartBeatListener var1);

    public void removeHeartBeatListener(HeartBeatListener var1);

    public static class TraceLifeRange {
        private long startTS;
        private long endTS;
        private boolean closed = false;

        public TraceLifeRange(long startTS) {
            this.startTS = startTS;
        }

        public TraceLifeRange(long startTS, long endTS) {
            if (endTS < startTS) {
                throw new IllegalArgumentException("The end time stamp of the trace life range could not be less than start time stamp!");
            }
            this.startTS = startTS;
            this.endTS = endTS;
            this.closed = true;
        }

        public long getEndTS() {
            return this.endTS;
        }

        public void setEndTS(long endTS) {
            this.endTS = endTS < this.startTS ? this.startTS : endTS;
            this.closed = true;
        }

        public long getStartTS() {
            return this.startTS;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    public static class SlimGcStatistic {
        private long dureation;
        private long timeMills;
        private long memSizeBefore;
        private long gcNr;
        private String cause;

        public SlimGcStatistic(HeartBeatGCStatistic gcStat) {
            this.gcNr = gcStat.getGcNr();
            this.dureation = gcStat.getDuration();
            this.timeMills = gcStat.getTimeMillis();
            this.memSizeBefore = gcStat.getMemSizeBefore();
            this.cause = gcStat.getCause().getDescription();
        }

        public String getCause() {
            return this.cause;
        }

        public long getGcNr() {
            return this.gcNr;
        }

        public long getDuration() {
            return this.dureation;
        }

        public long getTimeMillis() {
            return this.timeMills;
        }

        public long getMemSizeBefore() {
            return this.memSizeBefore;
        }
    }
}

