/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.impl.trace.MethodParameterTraceImpl;
import com.sap.jvm.profiling.controller.trace.ProfilingTrace;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import com.sap.jvm.profiling.method.response.MethodParameterIncludeType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MethodParameterTraceSpec
extends ProfilingTraceSpec {
    public static final boolean INCLUDE_TIME_STAMP = true;
    public static final boolean INCLUDE_CPU_TIME = true;
    public static final boolean INCLUDE_STACK_TRACE = true;
    private List<RequestedMethodParameter> parameters;
    private final boolean includeTimeStamp;
    private final boolean includeCpuTime;
    private final boolean includeStackTrace;

    public static MethodParameterTraceSpec read(ResourceReader reader) throws IOException {
        ArrayList<RequestedMethodParameter> parameters = new ArrayList<RequestedMethodParameter>();
        int nrOfParameters = reader.readInt8();
        boolean includeTimeStamp = reader.readBoolean();
        boolean incudeCpuTime = reader.readBoolean();
        boolean includeStackTrace = reader.readBoolean();
        for (int i = 0; i < nrOfParameters; ++i) {
            String specName = reader.readString();
            String description = reader.readString();
            String method = reader.readString();
            byte index = reader.readInt8();
            byte includeType = reader.readInt8();
            int nrOfModifiers = reader.readInt8();
            ArrayList<String> modifiers = new ArrayList<String>();
            for (int j = 0; j < nrOfModifiers; ++j) {
                modifiers.add(reader.readString());
            }
            RequestedMethodParameter parameter = new RequestedMethodParameter(specName, description, method, (int)index, MethodParameterIncludeType.get((byte)includeType), modifiers);
            parameters.add(parameter);
        }
        return new MethodParameterTraceSpec(parameters, includeTimeStamp, incudeCpuTime, includeStackTrace);
    }

    public MethodParameterTraceSpec(List<RequestedMethodParameter> parameters, boolean includeTimeStamp, boolean includeCpuTime, boolean includeStackTrace) {
        this.parameters = parameters;
        this.includeTimeStamp = includeTimeStamp;
        this.includeCpuTime = includeCpuTime;
        this.includeStackTrace = includeStackTrace;
    }

    public List<RequestedMethodParameter> getRequestedParameters() {
        return this.parameters;
    }

    public boolean includeTimeStamp() {
        return this.includeTimeStamp;
    }

    public boolean includeCpuTime() {
        return this.includeCpuTime;
    }

    public boolean includeStackTrace() {
        return this.includeStackTrace;
    }

    public void write(ResourceWriter writer) throws IOException {
        int nrOfParameters = this.parameters == null ? 0 : this.parameters.size();
        writer.writeInt8(nrOfParameters);
        writer.writeBoolean(this.includeTimeStamp);
        writer.writeBoolean(this.includeCpuTime);
        writer.writeBoolean(this.includeStackTrace);
        if (this.parameters != null) {
            for (RequestedMethodParameter parameter : this.parameters) {
                writer.writeString(parameter.getName());
                writer.writeString(parameter.getDescription());
                writer.writeString(parameter.getMethod());
                writer.writeInt8(parameter.getIndex());
                writer.writeInt8((int)parameter.getIncludeType().getType());
                List modifiers = parameter.getModifiers();
                writer.writeInt8(modifiers.size());
                for (int i = 0; i < modifiers.size(); ++i) {
                    writer.writeString((String)modifiers.get(i));
                }
            }
        }
    }

    @Override
    public ProfilingTrace createTrace(String name, ProfilingSession session) {
        return new MethodParameterTraceImpl(name, this, session);
    }

    @Override
    public String getTraceName() {
        return "Method Parameter Trace";
    }
}

