/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.impl.trace.PerformanceHotspotTraceImpl;
import com.sap.jvm.profiling.controller.trace.ProfilingTrace;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import java.util.List;

public final class PerformanceHotspotTraceSpec
extends ProfilingTraceSpec {
    public static final int MAX_STACK_TRACE_SIZE = -1;
    public static final boolean IGNORE_SLEEPING_THREADS = true;
    private String userFilter = "**";
    private boolean ignoreSleepingThreads = true;
    private List<RequestedMethodParameter> parameters;
    public static final boolean SMOOTH = true;
    private boolean smooth = true;

    public String getUserFilter() {
        return this.userFilter;
    }

    public boolean isFilteringUser() {
        return PerformanceHotspotTraceSpec.isFiltering(this.userFilter);
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = PerformanceHotspotTraceSpec.isFiltering(userFilter) ? userFilter : "**";
    }

    public void ignoreSleepingThreads() {
        this.ignoreSleepingThreads = true;
    }

    public void reportSleepingThreads() {
        this.ignoreSleepingThreads = false;
    }

    public boolean isIgnoringSleepingThreads() {
        return this.ignoreSleepingThreads;
    }

    public void setRequestedMethodParameters(List<RequestedMethodParameter> parameters) {
        this.parameters = parameters;
    }

    public List<RequestedMethodParameter> getRequestedMethodParameters() {
        return this.parameters;
    }

    public static boolean isFiltering(String pattern) {
        return pattern.length() > 0 && !"**".equals(pattern) && !"*".equals(pattern);
    }

    public boolean getSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean smooth) {
        this.smooth = smooth;
    }

    @Override
    public ProfilingTrace createTrace(String name, ProfilingSession session) {
        return new PerformanceHotspotTraceImpl(name, this, session);
    }

    @Override
    public String getTraceName() {
        return "Performance Hotspot Trace";
    }
}

