/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.util;

import com.sap.jvm.profiling.controller.model.Model;
import com.sap.jvm.profiling.snapshot.SnapshotStore;

public class SnapshotNameSuggestor {
    private final String name;
    private final String baseName;

    public SnapshotNameSuggestor(String name, String defaultName, Model<?> model) {
        String tmpName;
        String tmpBaseName = tmpName = name;
        int baseLen = tmpBaseName.length();
        while (baseLen > 0 && Character.isDigit(tmpBaseName.charAt(baseLen - 1))) {
            tmpBaseName = tmpBaseName.substring(0, --baseLen);
        }
        if (baseLen == 0) {
            tmpBaseName = defaultName;
        }
        tmpName = tmpBaseName = tmpBaseName.trim();
        SnapshotStore<?> store = model.getSnapshotStore();
        block1: for (int i = 0; i < store.size(); ++i) {
            if (!store.get(i).getName().equals(tmpName)) continue;
            int suffix = 2;
            while (true) {
                tmpName = tmpBaseName + " " + suffix;
                boolean found = false;
                for (int j = 0; j < store.size(); ++j) {
                    if (!store.get(j).getName().equals(tmpName)) continue;
                    found = true;
                    break;
                }
                if (!found) continue block1;
                ++suffix;
            }
        }
        this.name = tmpName;
        this.baseName = tmpBaseName;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

