/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.dictionary;

import com.sap.jvm.tracing.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class ClassNameDictionary {
    public static final String HEADER_DICT = "SAP-JVM Type Dictionary";
    private static final Type[] PRIMITIVES = new Type[]{new Type("int"), new Type("long"), new Type("double"), new Type("char"), new Type("float"), new Type("short"), new Type("byte"), new Type("boolean"), new Type("void")};
    public ArrayList<Package> packages = new ArrayList(1000);
    private ProgressStatistic statistic = new ProgressStatistic();

    public static ClassNameDictionary load(String path, ProgressReporter reporter) {
        try {
            return ClassNameDictionary.load(new FileInputStream(path), reporter);
        }
        catch (FileNotFoundException e) {
            Trace.error((Throwable)e, (String)"Problems on loading the dictionary!");
            return null;
        }
    }

    public static ClassNameDictionary load(InputStream input, ProgressReporter reporter) {
        ClassNameDictionary dic = new ClassNameDictionary();
        try {
            DataInputStream in = new DataInputStream(input);
            String header = in.readUTF();
            int version = in.readInt();
            if (!header.equals(HEADER_DICT)) {
                reporter.error("Invalid dictionary file!");
                return null;
            }
            int pLength = in.readInt();
            reporter.newTask(pLength, "Version (" + version + "). Loading the type pool...");
            for (int pPos = 0; pPos < pLength; ++pPos) {
                Package p = new Package(in.readUTF());
                dic.packages.add(p);
                int tLength = in.readInt();
                for (int tPos = 0; tPos < tLength; ++tPos) {
                    CType type = CType.values()[in.readByte()];
                    Type t = new Type(in.readUTF(), p, type);
                    p.types.add(t);
                }
                reporter.worked(pPos + 1, p.getPackageName());
            }
            int mLength = in.readInt();
            reporter.newTask(mLength, "Loading and resolving the methods...");
            for (int m = 0; m < mLength; ++m) {
                Method method = null;
                int pPos = in.readInt();
                int tPos = in.readInt();
                Type type = dic.packages.get((int)pPos).types.get(tPos);
                boolean isStatic = in.readByte() == 0;
                boolean isConstructor = in.readByte() == 0;
                String name = isConstructor ? null : in.readUTF();
                Type[] signature = new Type[in.readByte()];
                for (int i = 0; i < signature.length; ++i) {
                    byte arrayD = in.readByte();
                    pPos = in.readInt();
                    tPos = in.readInt();
                    Type t = dic.getTypeAtPos(pPos, tPos);
                    assert (t != null);
                    signature[i] = arrayD > 0 ? new TypeArray(t, arrayD) : t;
                }
                if (isConstructor) {
                    method = new Method(type, signature);
                } else {
                    byte arrayD = in.readByte();
                    pPos = in.readInt();
                    tPos = in.readInt();
                    Type returnType = dic.getTypeAtPos(pPos, tPos);
                    assert (returnType != null);
                    returnType = arrayD > 0 ? new TypeArray(returnType, arrayD) : returnType;
                    method = new Method(name, type, signature, returnType, isStatic);
                }
                type.methods.add(method);
                reporter.worked(m + 1, method.getMethodName());
            }
        }
        catch (Exception e) {
            Trace.error((Throwable)e, (String)"Problems on loading the dictionary!");
        }
        return dic;
    }

    public ProgressStatistic getStatistic() {
        return this.statistic;
    }

    public void save(String path, ProgressReporter reporter) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(path));
            reporter.newTask(this.packages.size() * 2, "Saving dictionary...");
            int worked = 0;
            int methodCount = 0;
            out.writeUTF(HEADER_DICT);
            out.writeInt(1);
            out.writeInt(this.packages.size());
            for (Package p : this.packages) {
                out.writeUTF(p.packageSpec);
                out.writeInt(p.types.size());
                for (Type t : p.types) {
                    out.writeByte(t.type.ordinal());
                    out.writeUTF(t.className);
                    methodCount += t.methods.size();
                }
                reporter.worked(worked++, p.getPackageName());
            }
            out.writeInt(methodCount);
            for (Package p : this.packages) {
                for (Type t : p.types) {
                    int[] posType = this.getTypePos(t);
                    for (Method m : t.methods) {
                        int[] pos;
                        --methodCount;
                        out.writeInt(posType[0]);
                        out.writeInt(posType[1]);
                        out.writeByte(m.isStatic() ? 0 : 1);
                        out.writeByte(m.isConstructor() ? 0 : 1);
                        if (!m.isConstructor()) {
                            out.writeUTF(m.methodName);
                        }
                        out.writeByte(m.signature.length);
                        for (Type sigT : m.signature) {
                            int[] pos2;
                            if (sigT instanceof TypeArray) {
                                TypeArray sigTArr = (TypeArray)sigT;
                                out.writeByte(sigTArr.getDimension());
                                pos2 = this.getTypePos(sigTArr.base);
                            } else {
                                out.writeByte(0);
                                pos2 = this.getTypePos(sigT);
                            }
                            out.writeInt(pos2[0]);
                            out.writeInt(pos2[1]);
                        }
                        if (m.isConstructor()) continue;
                        if (m.returnType instanceof TypeArray) {
                            TypeArray retTArr = (TypeArray)m.returnType;
                            out.writeByte(retTArr.getDimension());
                            pos = this.getTypePos(retTArr.base);
                        } else {
                            out.writeByte(0);
                            pos = this.getTypePos(m.returnType);
                        }
                        out.writeInt(pos[0]);
                        out.writeInt(pos[1]);
                    }
                }
                reporter.worked(worked++, p.getPackageName());
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sort() {
        Collections.sort(this.packages, new Comparator<Package>(){

            @Override
            public int compare(Package o1, Package o2) {
                return o1.packageSpec.compareTo(o2.packageSpec);
            }
        });
        for (Package p : this.packages) {
            p.sort();
        }
    }

    private Type findType(String type) {
        String baseType = type;
        int idx = 0;
        int arrayDimension = 0;
        while ((idx = type.indexOf(91, idx)) != -1) {
            ++arrayDimension;
            ++idx;
        }
        if (arrayDimension > 0) {
            baseType = type.substring(0, type.indexOf(91));
        }
        for (Type t : PRIMITIVES) {
            if (!t.getTypeName().equals(baseType)) continue;
            return arrayDimension > 0 ? new TypeArray(t, arrayDimension) : t;
        }
        for (Package p : this.packages) {
            if (!baseType.startsWith(p.getPackageName())) continue;
            for (Type t : p.types) {
                if (!t.getFullQualifiedName().equals(baseType)) continue;
                return arrayDimension > 0 ? new TypeArray(t, arrayDimension) : t;
            }
        }
        return null;
    }

    private int[] getTypePos(Type type) {
        if (type.type == CType.PRIMITIVE) {
            for (int i = 0; i < PRIMITIVES.length; ++i) {
                if (PRIMITIVES[i] != type) continue;
                return new int[]{-1, i};
            }
            return null;
        }
        return new int[]{this.packages.indexOf(type.pack), ((Type)type).pack.types.indexOf(type)};
    }

    private Type getTypeAtPos(int pIdx, int tIdx) {
        if (pIdx == -1) {
            return PRIMITIVES[tIdx];
        }
        return this.packages.get((int)pIdx).types.get(tIdx);
    }

    private boolean append(String clazz, ClassLoader cl, boolean checkMethods) {
        try {
            Class<?> c = cl.loadClass(clazz);
            Package pack = null;
            String packageName = c.getPackage().getName();
            for (Package p : this.packages) {
                if (!packageName.equals(p.getPackageName())) continue;
                pack = p;
                break;
            }
            if (pack == null) {
                pack = new Package(packageName);
                this.packages.add(pack);
                this.statistic.packages++;
            }
            Type type = null;
            String typeName = this.resolveInnerClass(c, true);
            for (Type t : pack.types) {
                if (!typeName.equals(t.getTypeName())) continue;
                type = t;
                break;
            }
            if (type == null) {
                CType cType = CType.CLASS;
                if (c.isInterface()) {
                    cType = CType.INTERFACE;
                    this.statistic.interfaces++;
                } else if (c.isEnum()) {
                    cType = CType.ENUM;
                    this.statistic.enums++;
                } else {
                    this.statistic.classes++;
                }
                if (c.getClassLoader() == cl) {
                    this.statistic.typesFromCL++;
                }
                type = new Type(typeName, pack, cType);
                pack.types.add(type);
            }
            if (checkMethods) {
                try {
                    for (Constructor<?> constructor : c.getConstructors()) {
                        for (Class<?> c2 : constructor.getParameterTypes()) {
                            this.updateTypes(c2, cl);
                        }
                    }
                    for (Executable executable : c.getDeclaredMethods()) {
                        for (Class<?> c2 : ((java.lang.reflect.Method)executable).getParameterTypes()) {
                            this.updateTypes(c2, cl);
                        }
                        this.updateTypes(((java.lang.reflect.Method)executable).getReturnType(), cl);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void updateTypes(Class<?> clazz, ClassLoader cl) {
        String className = this.getFQName(clazz, false);
        if (className.indexOf(91) > 0) {
            className = className.substring(0, className.lastIndexOf(91));
        }
        if (this.findType(className) == null) {
            this.append(className, cl, true);
        }
    }

    private void resolveMethods(ClassLoader loader, ProgressReporter reporter) {
        int toWork = this.statistic.classes + this.statistic.enums + this.statistic.interfaces;
        reporter.newTask(toWork, "Resolving the class methods...");
        toWork = 0;
        for (Package p : this.packages) {
            for (Type t : p.types) {
                reporter.worked(++toWork, t.getFullQualifiedName());
                try {
                    boolean breaked;
                    Type[] params;
                    Class<?> clazz = loader.loadClass(t.getFullQualifiedName());
                    for (java.lang.reflect.Method method : clazz.getDeclaredMethods()) {
                        params = new Type[method.getParameterTypes().length];
                        breaked = false;
                        for (int i = 0; i < params.length; ++i) {
                            Class<?> pType = method.getParameterTypes()[i];
                            String typeName = this.getFQName(pType, false);
                            Type type = this.findType(typeName);
                            if (type == null) {
                                breaked = true;
                                break;
                            }
                            params[i] = type;
                        }
                        if (!breaked) {
                            Type returnType = this.findType(method.getReturnType().getCanonicalName());
                            if (returnType == null) continue;
                            Method method2 = new Method(method.getName(), t, params, returnType, Modifier.isStatic(method.getModifiers()));
                            t.methods.add(method2);
                            this.statistic.methods++;
                            continue;
                        }
                        this.statistic.ignoredMethodsCount++;
                        this.statistic.ignoredMethods.add(this.getFullMethodName(method));
                    }
                    for (Executable executable : clazz.getConstructors()) {
                        params = new Type[((Constructor)executable).getParameterTypes().length];
                        breaked = false;
                        for (int i = 0; i < params.length; ++i) {
                            String typeName = this.getFQName(((Constructor)executable).getParameterTypes()[i], false);
                            Type type = this.findType(typeName);
                            if (type == null) {
                                breaked = true;
                                break;
                            }
                            params[i] = type;
                        }
                        if (!breaked) {
                            Method method = new Method(t, params);
                            t.methods.add(method);
                            this.statistic.constructors++;
                            continue;
                        }
                        this.statistic.ignoredConstructorsCount++;
                        this.statistic.ignoredConstructors.add(this.getFullConstructorName((Constructor<?>)executable));
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    private String getFQName(Class<?> type, boolean simple) {
        Class<?> baseType = type;
        if (type.isArray() && type.getComponentType().isMemberClass()) {
            baseType = type.getComponentType();
            String typeName = this.resolveInnerClass(baseType, simple);
            return typeName + "[]";
        }
        String typeName = this.resolveInnerClass(baseType, simple);
        return typeName;
    }

    private String resolveInnerClass(Class<?> type, boolean simple) {
        if (type.isMemberClass()) {
            return this.resolveInnerClass(type.getDeclaringClass(), simple) + '$' + type.getSimpleName();
        }
        return simple ? type.getSimpleName() : type.getCanonicalName();
    }

    private String getFullConstructorName(Constructor<?> cn) {
        StringBuilder method = new StringBuilder(cn.getDeclaringClass().getSimpleName());
        method.append(".<init>(");
        Class<?>[] types = cn.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            method.append(types[i].getSimpleName());
            if (i + 1 >= types.length) continue;
            method.append(',');
        }
        method.append(')');
        return method.toString();
    }

    private String getFullMethodName(java.lang.reflect.Method m) {
        StringBuilder method = new StringBuilder(m.getDeclaringClass().getSimpleName());
        method.append('.');
        method.append(m.getName());
        method.append('(');
        Class<?>[] types = m.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            method.append(types[i].getSimpleName());
            if (i + 1 >= types.length) continue;
            method.append(',');
        }
        method.append(')');
        method.append(m.getReturnType().getSimpleName());
        return method.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendJars(ClassNameDictionary dict, String[] jars, ProgressReporter reporter) {
        JarFileLoader cl = new JarFileLoader();
        ZipFile file = null;
        try {
            cl.addFiles(jars);
            for (String jarPath : jars) {
                if (file != null) {
                    file.close();
                }
                file = new JarFile(jarPath);
                reporter.newTask(file.size(), "Reading " + file.getName());
                int items = 0;
                Enumeration<JarEntry> en = ((JarFile)file).entries();
                while (en.hasMoreElements()) {
                    dict.statistic.jarEntries++;
                    JarEntry e = en.nextElement();
                    String clazz = e.getName();
                    reporter.worked(++items, e.getName());
                    if (!clazz.endsWith(".class")) continue;
                    dict.statistic.jarClassEntries++;
                    clazz = clazz.substring(0, clazz.indexOf(46));
                    if (clazz.indexOf(36) != -1) {
                        String subClass = clazz.substring(clazz.indexOf(36) + 1);
                        try {
                            if (subClass.indexOf(36) == -1) {
                                Integer.parseInt(subClass);
                            }
                            dict.statistic.ignoredJarAnonymousTypes++;
                        }
                        catch (NumberFormatException ex) {
                            clazz = clazz.replace('/', '.');
                            if (dict.append(clazz, cl, true)) {
                                dict.statistic.innerJarTypes++;
                                continue;
                            }
                            dict.statistic.ignoredInnerJarTypesCount++;
                            dict.statistic.ignoredInnerJarTypes.add(subClass);
                        }
                        continue;
                    }
                    if (dict.append(clazz = clazz.replace('/', '.'), cl, true)) {
                        dict.statistic.jarTypes++;
                        continue;
                    }
                    dict.statistic.ignoredJarTypesCount++;
                    dict.statistic.ignoredJarTypes.add(clazz);
                }
            }
            dict.resolveMethods(cl, reporter);
            dict.sort();
        }
        catch (Exception e) {
            Trace.error((Throwable)e, () -> "The dictionary could not be updated: " + e.getMessage());
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    ZipFile finalFile = file;
                    Trace.error((Throwable)e, () -> ClassNameDictionary.lambda$appendJars$1((JarFile)finalFile, e));
                }
            }
        }
        System.out.print(dict.statistic);
    }

    private static /* synthetic */ String lambda$appendJars$1(JarFile finalFile, IOException e) {
        return "Error while closing jar file (" + finalFile + "): " + e.getMessage();
    }

    public static class ProgressStatistic {
        private int jarEntries;
        private int jarClassEntries;
        private int innerJarTypes;
        private int ignoredInnerJarTypesCount;
        private List<String> ignoredInnerJarTypes = new ArrayList<String>();
        private int ignoredJarAnonymousTypes;
        private int jarTypes;
        private int ignoredJarTypesCount;
        private List<String> ignoredJarTypes = new ArrayList<String>();
        private int packages;
        private int interfaces;
        private int enums;
        private int classes;
        private int typesFromCL;
        private int methods;
        private int ignoredMethodsCount;
        private List<String> ignoredMethods = new ArrayList<String>();
        private int constructors;
        private int ignoredConstructorsCount;
        private List<String> ignoredConstructors = new ArrayList<String>();

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append('\n');
            out.append("Dictionary Progress Statistic");
            out.append('\n');
            out.append("-----------------------------");
            out.append('\n');
            out.append("Seen JAR entries..................... " + this.jarEntries);
            out.append('\n');
            out.append("Seen .class entries.................. " + this.jarClassEntries);
            out.append('\n');
            out.append("Seen type entries.................... " + this.jarTypes);
            out.append('\n');
            out.append("Seen and ignored type entries........ " + this.ignoredJarTypesCount);
            out.append('\n');
            out.append("Seen inner entries................... " + this.innerJarTypes);
            out.append('\n');
            out.append("Seen and ignored inner entries....... " + this.ignoredInnerJarTypesCount);
            out.append('\n');
            out.append("Seen and ignored anonymous entries... " + this.ignoredInnerJarTypesCount);
            out.append("\n\n");
            out.append("Packages............................. " + this.packages);
            out.append('\n');
            out.append("Interfaces........................... " + this.interfaces);
            out.append('\n');
            out.append("Enums................................ " + this.enums);
            out.append('\n');
            out.append("Classes.............................. " + this.classes);
            out.append('\n');
            out.append("Types Loaded from jars............... " + this.typesFromCL);
            out.append("\n\n");
            out.append("Methods.............................. " + this.methods);
            out.append('\n');
            out.append("Unresolved methods................... " + this.ignoredMethodsCount);
            out.append('\n');
            out.append("Constructors......................... " + this.constructors);
            out.append('\n');
            out.append("Unresolved constructors.............. " + this.ignoredConstructorsCount);
            out.append("\n\n");
            out.append(" [ Unresolved Types ]\n");
            for (String t : this.ignoredJarTypes) {
                out.append("    ");
                out.append(t);
                out.append('\n');
            }
            out.append(" [ Unresolved Inner Types ]\n");
            for (String t : this.ignoredInnerJarTypes) {
                out.append("    ");
                out.append(t);
                out.append('\n');
            }
            out.append(" [ Unresolved Methods ]\n");
            for (String t : this.ignoredMethods) {
                out.append("    ");
                out.append(t);
                out.append('\n');
            }
            out.append(" [ Unresolved Constructors ]\n");
            for (String t : this.ignoredConstructors) {
                out.append("    ");
                out.append(t);
                out.append('\n');
            }
            return out.toString();
        }

        public int getJarEntries() {
            return this.jarEntries;
        }

        public int getJarClassEntries() {
            return this.jarClassEntries;
        }

        public int getInnerJarTypes() {
            return this.innerJarTypes;
        }

        public int getIgnoredInnerJarTypesCount() {
            return this.ignoredInnerJarTypesCount;
        }

        public List<String> getIgnoredInnerJarTypes() {
            return this.ignoredInnerJarTypes;
        }

        public int getIgnoredJarAnonymousTypes() {
            return this.ignoredJarAnonymousTypes;
        }

        public int getJarTypes() {
            return this.jarTypes;
        }

        public int getIgnoredJarTypesCount() {
            return this.ignoredJarTypesCount;
        }

        public List<String> getIgnoredJarTypes() {
            return this.ignoredJarTypes;
        }

        public int getPackages() {
            return this.packages;
        }

        public int getInterfaces() {
            return this.interfaces;
        }

        public int getEnums() {
            return this.enums;
        }

        public int getClasses() {
            return this.classes;
        }

        public int getTypesFromCL() {
            return this.typesFromCL;
        }

        public int getMethods() {
            return this.methods;
        }

        public int getIgnoredMethodsCount() {
            return this.ignoredMethodsCount;
        }

        public List<String> getIgnoredMethods() {
            return this.ignoredMethods;
        }

        public int getConstructors() {
            return this.constructors;
        }

        public int getIgnoredConstructorsCount() {
            return this.ignoredConstructorsCount;
        }

        public List<String> getIgnoredConstructors() {
            return this.ignoredConstructors;
        }
    }

    public static interface ProgressReporter {
        public void newTask(int var1, String var2);

        public void worked(int var1, String var2);

        public void error(String var1);
    }

    private static class JarFileLoader
    extends URLClassLoader {
        public JarFileLoader() {
            super(new URL[0]);
        }

        public void addFiles(String[] paths) throws MalformedURLException {
            for (String path : paths) {
                this.addFile(path);
            }
        }

        public void addFile(String path) throws MalformedURLException {
            this.addURL(new File(path).toURI().toURL());
        }
    }

    public static class Method {
        private Type type;
        private Type returnType;
        private Type[] signature;
        private String methodName;
        private boolean isConstructor;
        private boolean isStatic;

        private Method(String name, Type type, Type[] params, Type returnType, boolean isStatic) {
            this.type = type;
            this.signature = params;
            this.returnType = returnType;
            this.methodName = name;
            this.isStatic = isStatic;
            this.isConstructor = false;
        }

        private Method(Type type, Type[] params) {
            this.type = type;
            this.signature = params;
            this.methodName = "<init>";
            this.isConstructor = true;
        }

        public String getFullQualifiedMethodName() {
            StringBuilder name = new StringBuilder(this.type.getFullQualifiedName());
            name.append('.');
            name.append(this.methodName);
            return name.toString();
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getReturnType() {
            return this.returnType.getFullQualifiedName();
        }

        public String getSignature() {
            StringBuilder sig = new StringBuilder();
            for (int i = 0; i < this.signature.length; ++i) {
                sig.append(this.signature[i].getFullQualifiedName());
                if (i + 1 >= this.signature.length) continue;
                sig.append(',');
            }
            return sig.toString();
        }

        public boolean isConstructor() {
            return this.isConstructor;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public String getFullQualifiedName() {
            StringBuilder name = new StringBuilder(this.type.getFullQualifiedName());
            name.append('.');
            name.append(this.methodName);
            name.append('(');
            name.append(this.getSignature());
            name.append(')');
            if (!this.isConstructor) {
                name.append(this.getReturnType());
            }
            return name.toString();
        }

        public String getTypeName() {
            return this.type.getTypeName();
        }

        public boolean isClass() {
            return this.type.isClass();
        }

        public boolean isEnum() {
            return this.type.isEnum();
        }

        public boolean isInterface() {
            return this.type.isInterface();
        }

        public String getPackageName() {
            return this.type.getPackageName();
        }
    }

    private static class TypeArray
    extends Type {
        private Type base;
        private int dimension;

        private TypeArray(Type base, int dimension) {
            assert (base != null);
            assert (dimension > -1);
            this.base = base;
            this.dimension = dimension;
        }

        public int getDimension() {
            return this.dimension;
        }

        @Override
        public String getFullQualifiedName() {
            StringBuilder result = new StringBuilder(this.base.getTypeName());
            for (int i = 0; i < this.dimension; ++i) {
                result.append("[]");
            }
            return result.toString();
        }

        @Override
        public String getTypeName() {
            return this.base.getTypeName();
        }

        @Override
        public boolean isClass() {
            return this.base.isClass();
        }

        @Override
        public boolean isEnum() {
            return this.base.isEnum();
        }

        @Override
        public boolean isInterface() {
            return this.base.isInterface();
        }

        @Override
        public String getPackageName() {
            return this.base.getPackageName();
        }
    }

    public static class Type {
        private Package pack;
        private CType type;
        private String className;
        public List<Method> methods = new ArrayList<Method>();

        private Type() {
        }

        private Type(String primitive) {
            assert (primitive != null && primitive.trim().length() > 0);
            this.pack = null;
            this.className = primitive;
            this.type = CType.PRIMITIVE;
        }

        private Type(String name, Package pack, CType type) {
            assert (name != null && name.trim().length() > 0);
            assert (pack != null);
            assert (type != null);
            this.pack = pack;
            this.className = name;
            this.type = type;
        }

        private void sort() {
            Collections.sort(this.methods, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return o1.methodName.compareTo(o2.methodName);
                }
            });
        }

        public String getFullQualifiedName() {
            return this.type == CType.PRIMITIVE ? this.className : this.getPackageName() + '.' + this.className;
        }

        public String getTypeName() {
            return this.className;
        }

        public boolean isClass() {
            return this.type == CType.CLASS;
        }

        public boolean isEnum() {
            return this.type == CType.ENUM;
        }

        public boolean isInterface() {
            return this.type == CType.INTERFACE;
        }

        public String getPackageName() {
            return this.pack == null ? "" : this.pack.getPackageName();
        }
    }

    private static enum CType {
        CLASS,
        ENUM,
        INTERFACE,
        PRIMITIVE;

    }

    public static class Package {
        private String packageSpec;
        public List<Type> types = new ArrayList<Type>();

        private Package(String name) {
            this.packageSpec = name == null || name.trim().equals("") ? "<default>" : name;
        }

        private void sort() {
            Collections.sort(this.types, new Comparator<Type>(){

                @Override
                public int compare(Type o1, Type o2) {
                    return o1.className.compareTo(o2.className);
                }
            });
            for (Type t : this.types) {
                t.sort();
            }
        }

        public String getPackageName() {
            return this.packageSpec;
        }
    }
}

