/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.dictionary;

import com.sap.jvm.profiling.dictionary.ClassNameDictionary;
import com.sap.jvm.profiling.dictionary.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DictionaryBuilder {
    private JTree contentTree;
    private JFrame frame;
    private JToolBar dictNaviePanel;
    private JToolBar libsNaviPanel;
    private JLabel statusLabel;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Dictionary Reader/Builder");
        frame.setSize(500, 500);
        new DictionaryBuilder(frame);
        frame.setVisible(true);
    }

    public DictionaryBuilder(final JFrame frame) {
        this.frame = frame;
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        this.contentTree = new JTree(new Object[0]);
        JScrollPane scrolledTree = new JScrollPane(this.contentTree);
        this.contentTree.setBorder(new EmptyBorder(5, 5, 5, 5));
        scrolledTree.setBorder(new MatteBorder(1, 0, 0, 0, Color.GRAY));
        this.contentTree.setRootVisible(false);
        scrolledTree.setBackground(this.contentTree.getBackground());
        frame.getContentPane().add((Component)scrolledTree, "Center");
        this.attachDropListener(this.contentTree);
        this.attachCellRenderer(this.contentTree);
        this.dictNaviePanel = new JToolBar();
        this.dictNaviePanel.setLayout(new FlowLayout(0));
        final JTextField txtField = new JTextField(25);
        txtField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Model)DictionaryBuilder.this.contentTree.getModel()).filter(txtField.getText());
            }
        });
        txtField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ((Model)DictionaryBuilder.this.contentTree.getModel()).filter(txtField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }
        });
        this.dictNaviePanel.add(txtField);
        this.createToolbarButton(Icons.getSaveIcon(), "Save Dictionary", this.dictNaviePanel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final FileDialog dlg = new FileDialog((Frame)frame, "Save Dictionary", 1);
                dlg.setFile("*.dic");
                dlg.setVisible(true);
                final Model model = (Model)DictionaryBuilder.this.contentTree.getModel();
                ProgressBarWindow window = new ProgressBarWindow(frame, DictionaryBuilder.this.contentTree.getBackground()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    void performWithProgress(ClassNameDictionary.ProgressReporter reporter) {
                        model.dic.save(dlg.getDirectory() + dlg.getFile(), reporter);
                    }
                };
                window.setVisible(true);
            }
        });
        this.libsNaviPanel = new JToolBar();
        this.libsNaviPanel.setLayout(new FlowLayout(0));
        this.createToolbarButton(Icons.getDictionaryIcon(), "Build Dictionary", this.libsNaviPanel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressBarWindow window = new ProgressBarWindow(frame, DictionaryBuilder.this.contentTree.getBackground()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    void performWithProgress(ClassNameDictionary.ProgressReporter reporter) {
                        ClassNameDictionary dic = new ClassNameDictionary();
                        Model model = (Model)DictionaryBuilder.this.contentTree.getModel();
                        String[] jars = model.libs.toArray(new String[model.libs.size()]);
                        ClassNameDictionary.appendJars(dic, jars, reporter);
                        DictionaryBuilder.this.contentTree.setModel(new Model(dic));
                        int types = dic.getStatistic().getClasses() + dic.getStatistic().getEnums() + dic.getStatistic().getInterfaces();
                        DictionaryBuilder.this.showInfo(types + " Types " + dic.getStatistic().getMethods() + " Methods");
                        frame.getContentPane().remove(DictionaryBuilder.this.libsNaviPanel);
                        frame.getContentPane().add((Component)DictionaryBuilder.this.dictNaviePanel, "North");
                        frame.getContentPane().doLayout();
                        frame.getContentPane().validate();
                        frame.getContentPane().repaint();
                    }
                };
                window.setVisible(true);
            }
        });
        JPanel statusBar = new JPanel();
        statusBar.setLayout(new FlowLayout(0, 7, 5));
        statusBar.setBorder(BorderFactory.createEtchedBorder(0));
        this.statusLabel = new JLabel(" ");
        statusBar.add(this.statusLabel);
        frame.getContentPane().add((Component)statusBar, "South");
        this.addMenuBar();
    }

    private void addMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu("File");
        Menu helpMenu = new Menu("Help");
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        final MenuItem helpContents = new MenuItem("Help Contents...");
        helpMenu.add(helpContents);
        helpMenu.addSeparator();
        final MenuItem helpAbout = new MenuItem("About DictionaryBuilder");
        helpMenu.add(helpAbout);
        ActionListener actionDispacher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == helpContents || e.getSource() == helpAbout) {
                    // empty if block
                }
            }
        };
        this.frame.setMenuBar(menuBar);
        helpAbout.addActionListener(actionDispacher);
        helpContents.addActionListener(actionDispacher);
    }

    private void createToolbarButton(ImageIcon icon, String tooltip, JToolBar toolBar, ActionListener listener) {
        JButton but = new JButton(icon);
        but.setToolTipText(tooltip);
        but.setMargin(new Insets(2, 2, 2, 2));
        but.addActionListener(listener);
        toolBar.add(but);
    }

    private void showWarning(String warning) {
        this.statusLabel.setIcon(Icons.getWarningIcon());
        this.statusLabel.setText(warning);
    }

    private void showError(String error) {
        this.statusLabel.setIcon(Icons.getErrorIcon());
        this.statusLabel.setText(error);
    }

    private void showInfo(String info) {
        this.statusLabel.setIcon(Icons.getInfoIcon());
        this.statusLabel.setText(info);
    }

    private void attachCellRenderer(JTree contentContainer) {
        contentContainer.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus2) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus2);
                if (value instanceof String) {
                    label.setText(value.toString());
                    label.setIcon(Icons.getJarIcon());
                }
                if (value instanceof ClassNameDictionary) {
                    label.setText("Dictionary");
                }
                if (value instanceof ClassNameDictionary.Package) {
                    label.setText(((ClassNameDictionary.Package)value).getPackageName());
                    label.setIcon(Icons.getPackageIcon());
                }
                if (value instanceof ClassNameDictionary.Type) {
                    ClassNameDictionary.Type type = (ClassNameDictionary.Type)value;
                    if (type.isClass()) {
                        label.setIcon(Icons.getClassIcon());
                    } else if (type.isInterface()) {
                        label.setIcon(Icons.getInterfaceIcon());
                    } else if (type.isEnum()) {
                        label.setIcon(Icons.getEnumIcon());
                    }
                    label.setText(((ClassNameDictionary.Type)value).getTypeName());
                }
                if (value instanceof ClassNameDictionary.Method) {
                    ClassNameDictionary.Method m = (ClassNameDictionary.Method)value;
                    StringBuilder result = new StringBuilder(m.getMethodName());
                    result.append('(');
                    result.append(m.getSignature());
                    result.append(')');
                    if (!m.isConstructor()) {
                        result.append(m.getReturnType());
                        label.setIcon(m.isStatic() ? Icons.getMethodStaticIcon() : Icons.getMethodIcon());
                    } else {
                        label.setIcon(Icons.getClassIcon());
                    }
                    label.setText(result.toString());
                }
                return label;
            }
        });
    }

    private void libsDroped(List<String> libs) {
        this.frame.getContentPane().remove(this.dictNaviePanel);
        this.frame.getContentPane().add((Component)this.libsNaviPanel, "North");
        this.frame.getContentPane().doLayout();
        this.frame.getContentPane().validate();
        this.frame.getContentPane().repaint();
        if (this.contentTree.getModel() instanceof Model) {
            Model model = (Model)this.contentTree.getModel();
            if (model.libs != null) {
                model.updateLibs(libs);
                return;
            }
        }
        this.contentTree.setModel(new Model(libs));
    }

    private void dictionaryDroped(final String path) {
        this.frame.getContentPane().remove(this.libsNaviPanel);
        this.frame.getContentPane().add((Component)this.dictNaviePanel, "North");
        this.frame.getContentPane().doLayout();
        this.frame.getContentPane().validate();
        this.frame.getContentPane().repaint();
        ProgressBarWindow window = new ProgressBarWindow(this.frame, this.contentTree.getBackground()){
            private static final long serialVersionUID = 1L;

            @Override
            void performWithProgress(ClassNameDictionary.ProgressReporter reporter) {
                ClassNameDictionary dic = ClassNameDictionary.load(path, reporter);
                if (dic != null) {
                    DictionaryBuilder.this.contentTree.setModel(new Model(dic));
                }
            }
        };
        window.setVisible(true);
    }

    private void attachDropListener(JTree contentContainer) {
        DropTargetListener dropTargetListener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    DataFlavor[] flavors = tr.getTransferDataFlavors();
                    for (int i = 0; i < flavors.length; ++i) {
                        if (!flavors[i].isFlavorJavaFileListType()) continue;
                        List files = (List)tr.getTransferData(flavors[i]);
                        if (files.size() == 1) {
                            String file = files.get(0).toString().toLowerCase();
                            if (file.endsWith("dic") || file.endsWith("jar")) {
                                e.acceptDrag(e.getDropAction());
                                return;
                            }
                            e.rejectDrag();
                            return;
                        }
                        Iterator iterator = files.iterator();
                        if (iterator.hasNext()) {
                            Object f = iterator.next();
                            if (!f.toString().toLowerCase().endsWith("jar")) {
                                e.rejectDrag();
                                return;
                            }
                            e.acceptDrag(e.getDropAction());
                            return;
                        }
                        e.rejectDrag();
                        return;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    e.rejectDrag();
                }
            }

            @Override
            public void dragExit(DropTargetEvent e) {
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    DataFlavor[] flavors = tr.getTransferDataFlavors();
                    for (int i = 0; i < flavors.length; ++i) {
                        if (!flavors[i].isFlavorJavaFileListType()) continue;
                        e.acceptDrop(e.getDropAction());
                        List transfereList = (List)tr.getTransferData(flavors[i]);
                        if (transfereList.size() == 1 && transfereList.get(0).toString().toLowerCase().trim().endsWith("dic")) {
                            DictionaryBuilder.this.dictionaryDroped(transfereList.get(0).toString());
                            e.dropComplete(true);
                            return;
                        }
                        ArrayList<String> libs = new ArrayList<String>();
                        for (int j = 0; j < transfereList.size(); ++j) {
                            libs.add(transfereList.get(j).toString());
                        }
                        DictionaryBuilder.this.libsDroped(libs);
                        e.dropComplete(true);
                        return;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent e) {
            }
        };
        new DropTarget(contentContainer, dropTargetListener);
    }

    public static abstract class ProgressBarWindow
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JProgressBar progressBar;

        public ProgressBarWindow(Frame frame, Color back) {
            super(frame, true);
            this.setModal(true);
            this.setUndecorated(true);
            this.setBackground(back);
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1, false));
            this.add((Component)mainPanel, "Center");
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            JPanel panel = new JPanel();
            panel.setBackground(back);
            panel.setLayout(new BorderLayout(5, 5));
            panel.add((Component)this.progressBar, "Center");
            mainPanel.add((Component)panel, "Center");
            panel.setBorder(new EmptyBorder(15, 15, 15, 15));
            final JLabel lblTask = new JLabel(" ");
            panel.add((Component)lblTask, "North");
            final JLabel lblWork = new JLabel(" ");
            panel.add((Component)lblWork, "South");
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Component c : frame.getComponents()) {
                c.setCursor(this.getCursor());
            }
            this.setResizable(false);
            this.pack();
            this.setSize((int)((double)frame.getWidth() * 0.75), this.getSize().height);
            this.setLocation(frame.getLocation().x + frame.getWidth() / 2 - this.getWidth() / 2, frame.getLocation().y + frame.getHeight() / 2);
            this.setDefaultCloseOperation(0);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    this.performWithProgress(new ClassNameDictionary.ProgressReporter(){

                        @Override
                        public void error(String msg) {
                            JOptionPane.showMessageDialog(null, msg, "Dictionary Error!", 0);
                        }

                        @Override
                        public void worked(final int worked, final String message) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        progressBar.setValue(worked);
                                        lblWork.setText(message);
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void newTask(final int toWork, final String message) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        progressBar.setValue(0);
                                        progressBar.setMaximum(toWork);
                                        lblTask.setText(message);
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    this.close();
                }
            }).start();
            this.setVisible(true);
        }

        void close() {
            this.setVisible(false);
            for (Component c : this.getParent().getComponents()) {
                c.setCursor(null);
            }
            this.getParent().setCursor(null);
            this.dispose();
        }

        abstract void performWithProgress(ClassNameDictionary.ProgressReporter var1);
    }

    private static class Model
    implements TreeModel {
        List<String> libs;
        ClassNameDictionary dic;
        List<ClassNameDictionary.Package> filteredPackage = new ArrayList<ClassNameDictionary.Package>();
        List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

        public Model(ClassNameDictionary dic) {
            this.dic = dic;
            for (ClassNameDictionary.Package p : dic.packages) {
                this.filteredPackage.add(p);
            }
        }

        public Model(List<String> libs) {
            this.libs = libs;
        }

        void filter(String pattern) {
            try {
                this.filteredPackage.clear();
                Pattern filter = Pattern.compile(pattern);
                for (ClassNameDictionary.Package p : this.dic.packages) {
                    if (!filter.matcher(p.getPackageName()).find()) continue;
                    this.filteredPackage.add(p);
                }
            }
            catch (Exception e) {
                this.filteredPackage.addAll(this.dic.packages);
            }
            TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.dic});
            for (TreeModelListener l : this.listeners) {
                l.treeStructureChanged(e);
            }
        }

        void updateLibs(List<String> newLibs) {
            for (String l : newLibs) {
                if (this.libs.indexOf(l) != -1) continue;
                this.libs.add(l);
            }
            TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.libs});
            for (TreeModelListener l : this.listeners) {
                l.treeStructureChanged(e);
            }
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.libs) {
                return this.libs.get(index);
            }
            if (parent instanceof ClassNameDictionary) {
                return this.filteredPackage.get(index);
            }
            if (parent instanceof ClassNameDictionary.Package) {
                return ((ClassNameDictionary.Package)parent).types.get(index);
            }
            if (parent instanceof ClassNameDictionary.Type) {
                return ((ClassNameDictionary.Type)parent).methods.get(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.libs) {
                return this.libs.size();
            }
            if (parent instanceof ClassNameDictionary) {
                return this.filteredPackage.size();
            }
            if (parent instanceof ClassNameDictionary.Package) {
                return ((ClassNameDictionary.Package)parent).types.size();
            }
            if (parent instanceof ClassNameDictionary.Type) {
                return ((ClassNameDictionary.Type)parent).methods.size();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.libs) {
                return this.libs.indexOf(child);
            }
            if (parent instanceof ClassNameDictionary) {
                return this.filteredPackage.indexOf(child);
            }
            if (parent instanceof ClassNameDictionary.Package) {
                return ((ClassNameDictionary.Package)parent).types.indexOf(child);
            }
            if (parent instanceof ClassNameDictionary.Type) {
                return ((ClassNameDictionary.Type)parent).methods.indexOf(child);
            }
            return -1;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node == this.libs) {
                return this.libs.isEmpty();
            }
            if (node instanceof ClassNameDictionary) {
                return this.filteredPackage.isEmpty();
            }
            if (node instanceof ClassNameDictionary.Package) {
                return ((ClassNameDictionary.Package)node).types.isEmpty();
            }
            if (node instanceof ClassNameDictionary.Type) {
                return ((ClassNameDictionary.Type)node).methods.isEmpty();
            }
            return true;
        }

        @Override
        public Object getRoot() {
            return this.libs != null ? this.libs : this.dic;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }
}

