/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.dictionary;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.swing.JFileChooser;

public class IconsInterfaceGenerator {
    static final String HEXES = "0123456789ABCDEF";

    public static void main(String[] args) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            if (0 != chooser.showOpenDialog(null)) {
                return;
            }
            File outFile = new File(chooser.getSelectedFile().getAbsolutePath(), "Icons.java");
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            PrintStream out = new PrintStream(outFile);
            out.println("package com.sap.jvm.profiling.dictionary;");
            out.println();
            out.println("import javax.imageio.ImageIO;");
            out.println("import javax.swing.ImageIcon;");
            out.println("import java.io.ByteArrayInputStream;");
            out.println();
            out.println("/**");
            out.println(" * This interface has been generated and should not be");
            out.println(" * altered manually.");
            out.println(" */");
            out.println("public class Icons {");
            out.println();
            File[] imgFiles = outFile.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String name = f.getName().toLowerCase();
                    return name.endsWith("gif") || name.endsWith("png");
                }
            });
            String[] names = new String[imgFiles.length];
            for (int i = 0; i < names.length; ++i) {
                String name = imgFiles[i].getName().toUpperCase();
                names[i] = name.substring(0, name.indexOf(46));
            }
            IconsInterfaceGenerator.generateGetters(names, out);
            for (File img : imgFiles) {
                IconsInterfaceGenerator.exportImage(img, out);
            }
            IconsInterfaceGenerator.generateInitializer(names, out);
            out.println("}");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private static void generateGetters(String[] names, PrintStream out) {
        for (String name : names) {
            out.println("    private static ImageIcon IMG_" + name + ";");
        }
        for (String name : names) {
            out.println();
            out.println("    /**");
            out.println("     * Returns the image " + name + " icon.");
            out.println("     *");
            out.println("     * @return " + name + " icon.");
            out.println("     */");
            out.println("    public static ImageIcon get" + name.charAt(0) + name.substring(1).toLowerCase() + "Icon() {");
            out.println("        return IMG_" + name + ";");
            out.println("    }");
        }
    }

    private static void generateInitializer(String[] names, PrintStream out) {
        out.println();
        out.println("    /**");
        out.println("     * Loading the icons.");
        out.println("     */");
        out.println("    static {");
        out.println("        try {");
        for (String name : names) {
            out.println("            IMG_" + name + " = new ImageIcon(ImageIO.read(");
            out.println("                new ByteArrayInputStream(BYTES_" + name + ")));");
        }
        out.println("        } catch (Exception e) {");
        out.println("            e.printStackTrace();");
        out.println("        }");
        out.println("    }");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportImage(File img, PrintStream out) {
        String name = img.getName().toUpperCase();
        name = name.substring(0, name.indexOf(46));
        out.println();
        out.println("    private final static byte[] BYTES_" + name + " = new byte[] {");
        try (FileInputStream in = new FileInputStream(img);){
            int b;
            int rows = 0;
            while ((b = ((InputStream)in).read()) != -1) {
                if (rows == 0) {
                    out.print("\n        ");
                    rows = 6;
                }
                out.print(IconsInterfaceGenerator.getHex(b));
                --rows;
            }
            out.println();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        out.println("    };");
    }

    public static String getHex(int b) {
        StringBuilder hex = new StringBuilder(2);
        hex.append(" (byte)0x").append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF)).append(',');
        return hex.toString();
    }
}

