/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.icons;

import com.sap.jvm.tracing.Trace;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class ImageRepository {
    private static Map<String, URL> URLCache = new HashMap<String, URL>();
    private static Map<String, URI> URICache = new HashMap<String, URI>();

    public static synchronized URL getImageURL(String key) {
        URL result = URLCache.get(key);
        if (result == null) {
            result = ImageRepository.class.getResource("resources/" + key);
            URLCache.put(key, result);
        }
        return result;
    }

    public static synchronized URI getImageURI(String key) {
        URI result = URICache.get(key);
        if (result == null) {
            try {
                result = ImageRepository.class.getResource("resources/" + key).toURI();
            }
            catch (URISyntaxException e) {
                Trace.error((Throwable)e, () -> "Could not convert URL to URI: " + ImageRepository.getImageURL(key).toExternalForm());
            }
            catch (NullPointerException e) {
                Trace.error((Throwable)e, () -> "Could not get image for key " + key);
            }
            if (result == null) {
                try {
                    result = ImageRepository.class.getResource("resources/decorators/warning.gif").toURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            URICache.put(key, result);
        }
        return result;
    }

    public static InputStream getImageInputStream(String key) {
        return ImageRepository.class.getResourceAsStream("resources/" + key);
    }
}

