/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.description.renderer;

import java.util.ArrayList;

public enum RendererStyle {
    HTML_BODY("font-family: Verdana, Tahoma, Arial, sans-serif;", "font-size: 9pt;"),
    HTML_TABLE("font-size: 9pt;"),
    GRAPH("width: 1000px;", "overflow: overlay;", "display:block;", "text-align: left;"),
    NOTE("font-family: verdana, 'lucida grande', tahoma, arial, sans-serif;", "background-color: #FFFFEF;", "padding: 10px 20px;", "width: 90%;", "overflow: visible;", "display: block;", "text-align: left;", "font-size: 90%;", "box-shadow: 3px 4px 5px -1px #D5D4C8;", "border: 1px solid #D3D3A1;", "border-radius: 4px;"),
    NOTE_WIDE("font-family: verdana, 'lucida grande', tahoma, arial, sans-serif;", "background-color: #FFFFEF;", "padding: 10px 20px;", "overflow: visible;", "display: block;", "text-align: left;", "font-size: 90%;", "box-shadow: 3px 4px 5px -1px #D5D4C8;", "border: 1px solid #D3D3A1;", "border-radius: 4px;"),
    TITLE("font-family: verdana, 'lucida grande', tahoma, arial, sans-serif;", "font-size: 141%;", "font-weight: bold;", "float: left;width: 100%;", "padding: 7px 20px;", "margin-top: 1.5em;", "margin-bottom: 1.2em;", "color: #194c7f;", "cursor: pointer;", "text-decoration: none;", "background: #f1f7fa;", "border-top: 1px solid #bec4cc;", "border-bottom: 4px solid #d6dde6;"),
    TITLE_PASSIVE("font-family: verdana, 'lucida grande', tahoma, arial, sans-serif;", "font-size: 141%;", "font-weight: bold;", "float: left;width: 100%;", "padding: 7px 20px;", "margin-top: 1.5em;", "margin-bottom: 1.2em;", "color: #c8e1f5;", "text-decoration: none;", "background: #f1f7fa;", "cursor: pointer;", "border-top: 1px solid #bec4cc;", "border-bottom: 4px solid #d6dde6;"),
    FIRST_TITLE("font-family: verdana, 'lucida grande', tahoma, arial, sans-serif;", "font-size: 141%;", "font-weight: bold;", "float: left;width: 100%;", "padding: 7px 20px;", "margin-bottom: 1.2em;", "color: #194c7f;", "text-decoration: none;", "background: #f1f7fa;", "cursor: pointer;", "border-top: 1px solid #bec4cc;", "border-bottom: 4px solid #d6dde6;"),
    FIRST_TITLE_PASSIVE("font-family: verdana, 'lucida grande', tahoma, arial, sans-serif;", "font-size: 141%;", "font-weight: bold;", "float: left;width: 100%;", "padding: 7px 20px;", "margin-bottom: 1.2em;", "text-decoration: none;", "color: #c8e1f5;", "background: #f1f7fa;", "cursor: pointer;", "border-top: 1px solid #bec4cc;", "border-bottom: 4px solid #d6dde6;"),
    NO_DECORATION_LINK("cursor: pointer;", "text-decoration: none;"),
    IMG("border: 0;", "vertical-align: middle;"),
    IMG_RIGHT("border: 0;", "float: right;", "vertical-align: middle;"),
    POST_ALIGN_NODE("display: inline-block;", "text-align: right;"),
    IE_POST_ALIGN_NODE("display: inline;", "text-align: right");

    private final String styleDefinition;

    private RendererStyle(String ... attrs) {
        StringBuilder styleDef = new StringBuilder();
        String indent = "            ";
        if (this.name().startsWith("HTML_")) {
            styleDef.append(this.name().toLowerCase().substring(5));
        } else if (this.name().startsWith("ID_")) {
            styleDef.append('#');
            styleDef.append(this.name().toLowerCase().substring(3));
        } else if (this.name().startsWith("IE_")) {
            String name = this.name().toLowerCase().substring(3);
            if (name.startsWith("id_")) {
                styleDef.append('#');
                name = name.substring(3);
            } else {
                styleDef.append('.');
            }
            styleDef.append(name);
            indent = indent + "    ";
        } else {
            styleDef.append('.');
            styleDef.append(this.name().toLowerCase());
        }
        styleDef.append(" { ");
        for (String a : attrs) {
            styleDef.append('\n');
            styleDef.append(indent);
            styleDef.append(a);
        }
        styleDef.append('\n');
        styleDef.append(indent);
        styleDef.append('}');
        this.styleDefinition = styleDef.toString();
    }

    public String getStyleDefinition() {
        return this.styleDefinition;
    }

    public static String getStyle() {
        ArrayList<RendererStyle> ieStyles = new ArrayList<RendererStyle>();
        StringBuilder styleDef = new StringBuilder("\n    <style type=\"text/css\">");
        for (RendererStyle style : RendererStyle.values()) {
            if (style.name().startsWith("IE_")) {
                ieStyles.add(style);
                continue;
            }
            styleDef.append("\n\n        ");
            styleDef.append(style.getStyleDefinition());
        }
        styleDef.append("\n    </style>\n");
        if (!ieStyles.isEmpty()) {
            styleDef.append("\n    <!--[if lt IE 10]>");
            styleDef.append("\n        <style type=\"text/css\">");
            for (RendererStyle style : ieStyles) {
                styleDef.append("\n\n            ");
                styleDef.append(style.getStyleDefinition());
            }
            styleDef.append("\n        </style>");
            styleDef.append("\n    <![endif]-->\n\n");
        }
        return styleDef.toString();
    }
}

