/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.description.renderer;

import java.util.HashMap;
import java.util.Map;

public class TableStyle {
    private String headerColor;
    private String contentColor;
    private final int[] contentCellPadding = new int[4];
    private final int[] headerCellPadding = new int[4];
    private final Map<Integer, Align> collsAlign = new HashMap<Integer, Align>();
    private final Map<Integer, Align> headerCollsAlign = new HashMap<Integer, Align>();

    public void setHeaderBackground(String color) {
        this.headerColor = color;
    }

    public void setContentBackground(String color) {
        this.contentColor = color;
    }

    public void setColumnAlignment(int col, Align align) {
        this.collsAlign.put(col + 1, align);
    }

    public Align getColumnAlignment(int col) {
        Align result = this.collsAlign.get(col + 1);
        if (result == null) {
            result = Align.LEFT;
        }
        return result;
    }

    public void setHeaderColumnAlignment(int col, Align align) {
        this.headerCollsAlign.put(col + 1, align);
    }

    public Align getHeaderColumnAlignment(int col) {
        Align result = this.headerCollsAlign.get(col + 1);
        if (result == null) {
            result = Align.LEFT;
        }
        return result;
    }

    public void setContentCellPadding(int top, int right, int bottom, int left) {
        this.contentCellPadding[0] = top;
        this.contentCellPadding[1] = left;
        this.contentCellPadding[2] = bottom;
        this.contentCellPadding[3] = right;
    }

    public void setHeaderCellPadding(int top, int right, int bottom, int left) {
        this.headerCellPadding[0] = top;
        this.headerCellPadding[1] = left;
        this.headerCellPadding[2] = bottom;
        this.headerCellPadding[3] = right;
    }

    public String getHTMLTableStyle(String styleId) {
        StringBuilder htmlStyle = new StringBuilder("<style type=\"text/css\">");
        String htmlTabeId = '#' + styleId;
        if (this.headerColor != null) {
            htmlStyle.append('\n');
            htmlStyle.append(htmlTabeId);
            htmlStyle.append(" thead {");
            htmlStyle.append(String.format(" background:%s;", this.headerColor));
            htmlStyle.append(" }");
        }
        if (!this.headerCollsAlign.isEmpty()) {
            htmlStyle.append('\n');
            htmlStyle.append(htmlTabeId).append(" th.left { text-align: left }\n");
            htmlStyle.append(htmlTabeId).append(" th.center { text-align: center }\n");
            htmlStyle.append(htmlTabeId).append(" th.right { text-align: right }");
        }
        if (!this.collsAlign.isEmpty()) {
            htmlStyle.append('\n');
            htmlStyle.append(htmlTabeId).append(" td.left { text-align: left }\n");
            htmlStyle.append(htmlTabeId).append(" td.center { text-align: center }\n");
            htmlStyle.append(htmlTabeId).append(" td.right { text-align: right }");
        }
        htmlStyle.append('\n');
        htmlStyle.append(htmlTabeId);
        htmlStyle.append(" th {");
        htmlStyle.append(String.format(" padding:%dpx %dpx %dpx %dpx", this.headerCellPadding[0], this.headerCellPadding[1], this.headerCellPadding[2], this.headerCellPadding[3]));
        htmlStyle.append(" }");
        if (this.contentColor != null) {
            htmlStyle.append('\n');
            htmlStyle.append(htmlTabeId);
            htmlStyle.append(" tbody {");
            htmlStyle.append(String.format(" background:%s;", this.contentColor));
            htmlStyle.append(" }");
        }
        htmlStyle.append('\n');
        htmlStyle.append(htmlTabeId);
        htmlStyle.append(" tbody td {");
        htmlStyle.append(String.format(" padding:%dpx %dpx %dpx %dpx", this.contentCellPadding[0], this.contentCellPadding[1], this.contentCellPadding[2], this.contentCellPadding[3]));
        htmlStyle.append(" }");
        htmlStyle.append('\n');
        htmlStyle.append("</style>");
        return htmlStyle.toString();
    }

    public static void main(String ... args) {
        TableStyle s = new TableStyle();
        s.setHeaderColumnAlignment(1, Align.CENTER);
        s.setColumnAlignment(1, Align.CENTER);
        s.setColumnAlignment(2, Align.JUSTIFY);
        s.setColumnAlignment(3, Align.RIGHT);
        s.setHeaderBackground("#fff");
        s.setContentBackground("#fff");
        s.setHeaderCellPadding(5, 6, 7, 8);
        System.out.println(s.getHTMLTableStyle("id"));
    }

    public static enum Align {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right"),
        JUSTIFY("justify");

        private String value;

        private Align(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

