/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.graph;

import com.sap.jvm.profiling.icons.ImageRepository;
import com.sap.jvm.profiling.presentation.impl.csv.CSVModelViewer;
import com.sap.jvm.profiling.presentation.impl.csv.CSVTimeSeriesExporter;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelModelViewer;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelTimeSeriesExporter;
import com.sap.jvm.profiling.presentation.impl.html.HTMLModelViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLTimeSeriesExporter;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlModelViewer;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlTimeSeriesExporter;
import com.sap.jvm.profiling.presentation.typed.XmlModelExporter;
import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationsImageFactory;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotation;
import com.sap.jvm.profiling.ui.graph.renderer.Image;
import com.sap.jvm.profiling.ui.graph.renderer.Renderer;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TimeSeriesUtils {
    public static HTMLModelExporter getHTMLExporter(TimeSeriesModel model, OSThemeSpec osTheme, LineGraphAnnotationsImageFactory imgFactory) {
        HTMLModelViewer viewer = new HTMLModelViewer();
        TimeSeriesModel copy = model.copy(viewer);
        return new HTMLTimeSeriesExporter(copy, osTheme, imgFactory);
    }

    public static HTMLModelExporter getHTMLExporter(TimeSeriesModel model, OSThemeSpec osTheme) {
        HTMLModelViewer viewer = new HTMLModelViewer();
        TimeSeriesModel copy = model.copy(viewer);
        LineGraphAnnotationsImageFactory imgFactory = new LineGraphAnnotationsImageFactory(){

            @Override
            public String provideImageKey(LineGraphAnnotation a, Renderer renderer) {
                if (a.getData() != null && a.getData() instanceof String) {
                    return (String)a.getData();
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Image provideImage(LineGraphAnnotation a, Renderer renderer) {
                InputStream stream;
                String iconKey = this.provideImageKey(a, renderer);
                if (iconKey != null && (stream = ImageRepository.getImageInputStream(iconKey)) != null) {
                    try {
                        int nRead;
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] data = new byte[16384];
                        while ((nRead = stream.read(data, 0, data.length)) != -1) {
                            buffer.write(data, 0, nRead);
                        }
                        byte[] rawImageData = buffer.toByteArray();
                        Image image = renderer.getImage(rawImageData);
                        return image;
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return null;
            }
        };
        return new HTMLTimeSeriesExporter(copy, osTheme, imgFactory);
    }

    public static CSVModelExporter getCSVExporter(TimeSeriesModel model) {
        CSVModelViewer viewer = new CSVModelViewer();
        TimeSeriesModel copy = model.copy(viewer);
        return new CSVTimeSeriesExporter(copy);
    }

    public static XmlModelExporter getXmlExporter(TimeSeriesModel model) {
        XmlModelViewer viewer = new XmlModelViewer();
        TimeSeriesModel copy = model.copy(viewer);
        return new XmlTimeSeriesExporter(copy);
    }

    public static ExcelModelExporter getExcelExporter(TimeSeriesModel model) {
        ExcelModelViewer viewer = new ExcelModelViewer();
        TimeSeriesModel copy = model.copy(viewer);
        return new ExcelTimeSeriesExporter(copy);
    }
}

