/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.graph;

import com.sap.jvm.profiling.presentation.impl.csv.CSVModelViewer;
import com.sap.jvm.profiling.presentation.impl.csv.CSVValueSetExporter;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelModelViewer;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelValueSetExporter;
import com.sap.jvm.profiling.presentation.impl.html.HTMLModelViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLValueSetExporter;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlModelViewer;
import com.sap.jvm.profiling.presentation.impl.typed.xml.XmlValueSetExporter;
import com.sap.jvm.profiling.presentation.typed.XmlModelExporter;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;

public class ValueSetUtils {
    public static HTMLModelExporter getHTMLExporter(ValueSetModel model, OSThemeSpec osTheme) {
        HTMLModelViewer viewer = new HTMLModelViewer();
        ValueSetModel copy = model.copy(viewer);
        return new HTMLValueSetExporter(copy, osTheme);
    }

    public static CSVModelExporter getCSVExporter(ValueSetModel model) {
        CSVModelViewer viewer = new CSVModelViewer();
        ValueSetModel copy = model.copy(viewer);
        return new CSVValueSetExporter(copy);
    }

    public static ExcelModelExporter getExcelExporter(ValueSetModel model) {
        ExcelModelViewer viewer = new ExcelModelViewer();
        ValueSetModel copy = model.copy(viewer);
        return new ExcelValueSetExporter(copy);
    }

    public static XmlModelExporter getXmlExporter(ValueSetModel model) {
        XmlModelViewer viewer = new XmlModelViewer();
        ValueSetModel copy = model.copy(viewer);
        return new XmlValueSetExporter(copy);
    }
}

