/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.csv;

import com.sap.jvm.profiling.presentation.impl.csv.CSVWriter;
import com.sap.jvm.profiling.presentation.impl.typed.csv.renderer.CSVRendererNode;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.table.TableModel;
import java.io.IOException;
import java.io.Writer;

public class CSVTableExporter
implements CSVModelExporter {
    private final TableModel model;
    private final boolean selectedOnly;

    public CSVTableExporter(TableModel model, boolean selectedOnly) {
        this.model = model;
        this.selectedOnly = selectedOnly;
    }

    @Override
    public void writeCSV(Writer stream, char decimalPoint, String comma, boolean includeColumnTitles, ProgressReporter reporter) throws IOException {
        CSVWriter writer = new CSVWriter(stream, decimalPoint, comma);
        int nrSkipped = 0;
        for (int i = 0; i < this.model.getNrOfItems(); ++i) {
            int itemId = this.model.getItemId(i);
            if (this.model.isSelected(itemId) || !this.selectedOnly) {
                if (nrSkipped > 0) {
                    this.addSkipped(writer);
                    nrSkipped = 0;
                }
                for (int column : this.model.getColumnOrder()) {
                    if (!this.model.isColumnVisible(column)) continue;
                    CSVRendererNode node = (CSVRendererNode)this.model.getRendererForItem(itemId, column);
                    writer.newCell();
                    node.add(writer, true);
                }
                writer.newLine();
                continue;
            }
            ++nrSkipped;
        }
        if (nrSkipped > 0) {
            this.addSkipped(writer);
        }
    }

    private void addSkipped(CSVWriter writer) {
        boolean isFirst = true;
        for (int column : this.model.getColumnOrder()) {
            if (!this.model.isColumnVisible(column)) continue;
            writer.newCell();
            if (!isFirst) continue;
            writer.add("...");
            isFirst = false;
        }
        writer.newLine();
    }
}

