/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.csv;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.csv.CSVWriter;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphVirtualDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class CSVTimeSeriesExporter
implements CSVModelExporter {
    private final TimeSeriesModel model;

    public CSVTimeSeriesExporter(TimeSeriesModel model) {
        this.model = model;
    }

    @Override
    public void writeCSV(Writer stream, char decimalPoint, String comma, boolean includeColumnTitles, ProgressReporter reporter) throws IOException {
        CSVWriter writer = new CSVWriter(stream, decimalPoint, comma);
        ArrayList<Iterator<Value2D>> its = new ArrayList<Iterator<Value2D>>();
        ArrayList<Double> scalesList = new ArrayList<Double>();
        long overallWork = 0L;
        TypedTimeSeriesModel typedModel = null;
        if (this.model instanceof TypedTimeSeriesModel) {
            typedModel = (TypedTimeSeriesModel)this.model;
        }
        for (int i = 0; i < this.model.getNrOfAreas(); ++i) {
            if (!this.model.isAreaVisible(i)) continue;
            for (int j = 0; j < this.model.getAreaSize(i); ++j) {
                String unit;
                Object graph = this.model.getGraph(i, j, 0L);
                if (!(graph instanceof LineGraphVirtualDataSet)) continue;
                LineGraphVirtualDataSet dataSet = (LineGraphVirtualDataSet)graph;
                overallWork += dataSet.getSize();
                its.add(dataSet.iterator());
                String string = unit = typedModel != null ? typedModel.getYAxisModel(i, j).getExportUnit() : "";
                if (includeColumnTitles) {
                    writer.newCell();
                    writer.add(I18n._s((String)"Timestamp for {0} (seconds)", (Object[])new Object[]{this.model.getGraphName(i, j)}));
                    writer.newCell();
                    if (unit.length() > 0) {
                        writer.add(I18n._s((String)"{0} ({1})", (Object[])new Object[]{this.model.getGraphName(i, j), unit}));
                    } else {
                        writer.add(I18n._s((String)"{0}", (Object[])new Object[]{this.model.getGraphName(i, j)}));
                    }
                }
                if (typedModel != null) {
                    scalesList.add(typedModel.getYAxisModel(i, j).getScale());
                    continue;
                }
                scalesList.add(1.0);
            }
        }
        if (includeColumnTitles) {
            writer.newLine();
        }
        double[] scales = new double[scalesList.size()];
        for (int i = 0; i < scales.length; ++i) {
            scales[i] = (Double)scalesList.get(i);
        }
        reporter.setWork(I18n._s((String)"Exporting to CSV... (<%> done)"), overallWork);
        boolean hasData = true;
        Value2D[] values = new Value2D[its.size()];
        while (hasData) {
            int i;
            hasData = false;
            for (i = 0; i < its.size(); ++i) {
                Iterator it = (Iterator)its.get(i);
                if (it.hasNext()) {
                    reporter.reportNextOrThrow();
                    hasData = true;
                    values[i] = (Value2D)((Iterator)its.get(i)).next();
                    continue;
                }
                values[i] = null;
            }
            if (!hasData) continue;
            for (i = 0; i < its.size(); ++i) {
                Value2D value = values[i];
                if (value != null) {
                    writer.newCell();
                    writer.add(value.x * 1.0E-6);
                    writer.newCell();
                    writer.add(value.y * scales[i]);
                    hasData = true;
                    continue;
                }
                writer.newCell();
                writer.add("");
                writer.newCell();
                writer.add("");
            }
            writer.newLine();
        }
    }
}

