/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.csv;

import com.sap.jvm.profiling.presentation.impl.csv.CSVWriter;
import com.sap.jvm.profiling.presentation.impl.typed.csv.renderer.CSVRendererNode;
import com.sap.jvm.profiling.presentation.tree.TreeUtils;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.io.IOException;
import java.io.Writer;

public class CSVTreeExporter
implements CSVModelExporter {
    private final TreeModel model;
    private final boolean selectedOnly;

    public CSVTreeExporter(TreeModel model, boolean selectedOnly) {
        this.model = model;
        this.selectedOnly = selectedOnly;
    }

    @Override
    public void writeCSV(Writer stream, char decimalPoint, String comma, boolean includeColumnTitles, ProgressReporter reporter) throws IOException {
        CSVWriter writer = new CSVWriter(stream, decimalPoint, comma);
        TreeUtils.prepareForExport(this.model, this.selectedOnly);
        this.writeItems(this.model.getRootItems(), 0, writer);
    }

    private void writeItems(TreeModelItem[] items, int indent, CSVWriter writer) {
        int nrSkipped = 0;
        for (TreeModelItem item : items) {
            if (item.isSelected()) {
                if (nrSkipped > 0) {
                    this.writeNotExported(writer, indent);
                    nrSkipped = 0;
                }
                boolean isFirst = true;
                for (int column : this.model.getColumnOrder()) {
                    if (!this.model.isColumnVisible(column)) continue;
                    writer.newCell();
                    if (isFirst) {
                        for (int i = 0; i < indent; ++i) {
                            writer.add(" ");
                        }
                    }
                    isFirst = false;
                    CSVRendererNode node = (CSVRendererNode)this.model.getRendererForItem(item, column);
                    if (node == null) continue;
                    node.add(writer, true);
                }
                writer.newLine();
                if (!item.isExpanded()) continue;
                this.writeItems(item.getSubsOrChildren(), indent + 1, writer);
                continue;
            }
            ++nrSkipped;
        }
        if (nrSkipped > 0) {
            this.writeNotExported(writer, indent);
        }
    }

    private void writeNotExported(CSVWriter writer, int indent) {
        boolean isFirst = true;
        for (int column : this.model.getColumnOrder()) {
            if (!this.model.isColumnVisible(column)) continue;
            writer.newCell();
            if (isFirst) {
                for (int i = 0; i < indent; ++i) {
                    writer.add(" ");
                }
                writer.add("...");
            }
            isFirst = false;
        }
        writer.newLine();
    }
}

