/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.csv;

import com.sap.jvm.profiling.presentation.impl.csv.CSVWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import java.io.IOException;
import java.io.Writer;

public class CSVValueSetExporter
implements CSVModelExporter {
    private final ValueSetModel model;

    public CSVValueSetExporter(ValueSetModel model) {
        this.model = model;
    }

    @Override
    public void writeCSV(Writer stream, char decimalPoint, String comma, boolean includeColumnTitles, ProgressReporter reporter) throws IOException {
        int i;
        CSVWriter writer = new CSVWriter(stream, decimalPoint, comma);
        writer.newCell();
        for (i = 0; i < this.model.getNrOfColumns(); ++i) {
            if (!this.model.isColumnVisible(i)) continue;
            writer.newCell();
            writer.add(this.model.getColumnName(i));
        }
        writer.newLine();
        for (i = 0; i < this.model.getNrOfRows(); ++i) {
            writer.newCell();
            writer.add(this.model.getRowName(i).toString());
            for (int j = 0; j < this.model.getNrOfColumns(); ++j) {
                if (!this.model.isColumnVisible(j)) continue;
                long value = this.model.getValue(i, j);
                writer.newCell();
                writer.add(value);
            }
            writer.newLine();
        }
    }
}

