/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.csv;

import com.sap.jvm.profiling.presentation.impl.csv.CSVQuoter;
import com.sap.jvm.profiling.presentation.impl.csv.Quoter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;

public class CSVWriter {
    private final Writer stream;
    private final String comma;
    private final Quoter quoter;
    private final char decimalPoint;
    private boolean isFirst = true;

    public CSVWriter(Writer stream, char decimalPoint, String comma) {
        this.stream = stream;
        this.comma = comma;
        this.decimalPoint = decimalPoint;
        this.quoter = new CSVQuoter(comma);
    }

    private void write(String content) {
        try {
            this.stream.write(content);
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Could not write");
        }
    }

    public void add(String content) {
        this.write(this.quoter.quote(content));
    }

    public void add(double value) {
        String result = new BigDecimal(value).toPlainString();
        if (this.decimalPoint != '.') {
            this.add(result.replace('.', this.decimalPoint));
        } else {
            this.add(result);
        }
    }

    public void add(long value) {
        this.add(Long.toString(value));
    }

    public void newCell() {
        if (!this.isFirst) {
            this.write(this.comma);
        } else {
            this.isFirst = false;
        }
    }

    public void newLine() {
        this.write("\r\n");
        this.isFirst = true;
    }
}

