/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.description;

import com.sap.jvm.profiling.presentation.description.DescriptionProvider;
import com.sap.jvm.profiling.presentation.impl.description.HTMLDescriptionViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.util.pair.ObjectPair;
import java.io.File;
import java.io.IOException;

public class DescriptionWriterImpl {
    public static void writeAsHtmlToDirectory(ResourceName name, String kind, DescriptionProvider provider, RendererThemeSpec themeSpec, File directory, ProgressReporter reporter) throws IOException {
        RendererThemeImpl theme = new RendererThemeImpl(themeSpec);
        HTMLSink sink = new HTMLSink("index.html", DescriptionWriterImpl.getOsTheme(), true, directory);
        HTMLDescriptionViewer viewer = new HTMLDescriptionViewer(sink, theme);
        viewer.addDescription(name, kind, (HTMLRendererNode)provider.getDescription(name, kind, viewer, reporter));
        while (viewer.hasUnknownLinks()) {
            ObjectPair<ResourceName, String> link = viewer.getUnknownLinks().iterator().next();
            ResourceName linkName = (ResourceName)link.getFirst();
            String linkKind = (String)link.getSecond();
            viewer.addDescription(linkName, linkKind, (HTMLRendererNode)provider.getDescription(linkName, linkKind, viewer, reporter));
        }
        File f = new File(directory, "index.html");
        sink.saveAsHTML(f, reporter);
    }

    private static OSThemeSpec getOsTheme() {
        return new OSThemeSpec(0, 0xFFFFFF, -1, -1, -1, -1, -1, -1);
    }
}

