/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.description;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.DescriptionViewer;
import com.sap.jvm.profiling.presentation.description.renderer.CollapseNode;
import com.sap.jvm.profiling.presentation.description.renderer.DescriptionLinkNode;
import com.sap.jvm.profiling.presentation.description.renderer.DivisionNode;
import com.sap.jvm.profiling.presentation.description.renderer.ExpandNode;
import com.sap.jvm.profiling.presentation.description.renderer.HyperLinkNode;
import com.sap.jvm.profiling.presentation.description.renderer.LineBreakNode;
import com.sap.jvm.profiling.presentation.description.renderer.Margin;
import com.sap.jvm.profiling.presentation.description.renderer.MarginNode;
import com.sap.jvm.profiling.presentation.description.renderer.NoLineBreakNode;
import com.sap.jvm.profiling.presentation.description.renderer.NopNode;
import com.sap.jvm.profiling.presentation.description.renderer.ParagraphNode;
import com.sap.jvm.profiling.presentation.description.renderer.RendererStyle;
import com.sap.jvm.profiling.presentation.description.renderer.StyleNode;
import com.sap.jvm.profiling.presentation.description.renderer.TableNode;
import com.sap.jvm.profiling.presentation.description.renderer.TableStyle;
import com.sap.jvm.profiling.presentation.description.renderer.ToggleNode;
import com.sap.jvm.profiling.presentation.description.renderer.ToolTipNode;
import com.sap.jvm.profiling.presentation.description.renderer.TreeNode;
import com.sap.jvm.profiling.presentation.description.renderer.TreeNodeItem;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLCollapseNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLDescriptionLinkNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLDivisionNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLExpandNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLHyperLinkNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLLineBreakNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLMarginNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLNoLineBreakNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLNopNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLParagraphNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLStyleNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLTableNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLToggleNode;
import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLToolTipNode;
import com.sap.jvm.profiling.presentation.impl.html.HTMLModelViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.util.pair.ObjectPair;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class HTMLDescriptionViewer
extends HTMLModelViewer
implements DescriptionViewer {
    private final HashMap<ObjectPair<ResourceName, String>, String> linkTargets;
    private final HashSet<ObjectPair<ResourceName, String>> unknownLinks;
    private int fileNr;
    private final HTMLSink sink;
    private final RendererTheme theme;

    public HTMLDescriptionViewer(HTMLSink sink, RendererTheme theme) {
        this.sink = sink;
        this.linkTargets = new HashMap();
        this.unknownLinks = new HashSet();
        this.fileNr = 0;
        this.theme = theme;
    }

    public Set<ObjectPair<ResourceName, String>> getUnknownLinks() {
        return this.unknownLinks;
    }

    public boolean hasUnknownLinks() {
        return !this.unknownLinks.isEmpty();
    }

    public void addDescription(ResourceName name, String kind, HTMLRendererNode node) {
        ObjectPair key = new ObjectPair((Object)name, (Object)kind);
        this.unknownLinks.remove(key);
        if (this.linkTargets.containsKey(key)) {
            this.sink.newHTML(this.linkTargets.get(key));
        } else {
            this.linkTargets.put((ObjectPair<ResourceName, String>)key, "index.html");
        }
        this.sink.startHead("", false, true, true);
        this.sink.startBody();
        if (node == null) {
            this.newTextNode(I18n._s((String)"No help currently available for resource '{0}'", (Object[])new Object[]{name}));
        } else {
            node.render(this.sink);
        }
        this.sink.endBody();
        this.sink.finishHTML();
    }

    public NopNode<HTMLRendererNode> newNopNode() {
        return new HTMLNopNode();
    }

    public DescriptionLinkNode<HTMLRendererNode> newDescriptionLinkNode(ResourceName name, String kind, RendererNode child) {
        ObjectPair key = new ObjectPair((Object)name, (Object)kind);
        if (this.linkTargets.containsKey(key)) {
            return new HTMLDescriptionLinkNode(name, kind, (HTMLRendererNode)child, this.linkTargets.get(key));
        }
        String target = "link-" + this.fileNr + ".html";
        ++this.fileNr;
        this.unknownLinks.add((ObjectPair<ResourceName, String>)key);
        this.linkTargets.put((ObjectPair<ResourceName, String>)key, target);
        return new HTMLDescriptionLinkNode(name, kind, (HTMLRendererNode)child, target);
    }

    public ParagraphNode<HTMLRendererNode> newParagraphNode(RendererNode child) {
        return new HTMLParagraphNode((HTMLRendererNode)child);
    }

    public TreeNode<HTMLRendererNode> newTreeNode(String[] headings, double[] relativeWidths, boolean showGrid, TreeNodeItem[] roots) {
        return null;
    }

    public TableNode<HTMLRendererNode> newTable(String[] headings, double[] relativeWidths, boolean showBorder, boolean showGrid, int alignment, RendererNode[][] content, TableStyle style) {
        return new HTMLTableNode(headings, relativeWidths, showBorder, showGrid, alignment, content, style);
    }

    public ToggleNode<HTMLRendererNode> newToggleNode(RendererNode collapsed, RendererNode expanded) {
        return new HTMLToggleNode((HTMLRendererNode)collapsed, (HTMLRendererNode)expanded);
    }

    public ToolTipNode<HTMLRendererNode> newToolTipNode(RendererNode child, String toolTip) {
        return new HTMLToolTipNode((HTMLRendererNode)child, toolTip);
    }

    public ExpandNode<HTMLRendererNode> newExpandNode(RendererNode child, ToggleNode<?> toggleNode) {
        return new HTMLExpandNode((HTMLRendererNode)child, new HTMLToggleNode[]{(HTMLToggleNode)toggleNode});
    }

    public ExpandNode<HTMLRendererNode> newExpandNode(RendererNode child, ToggleNode<?>[] toggleNodes) {
        HTMLToggleNode[] htmlToggleNodes = new HTMLToggleNode[toggleNodes.length];
        System.arraycopy(toggleNodes, 0, htmlToggleNodes, 0, toggleNodes.length);
        return new HTMLExpandNode((HTMLRendererNode)child, htmlToggleNodes);
    }

    public CollapseNode<HTMLRendererNode> newCollapseNode(RendererNode child) {
        return new HTMLCollapseNode((HTMLRendererNode)child);
    }

    public LineBreakNode<HTMLRendererNode> newLineBreakNode() {
        return new HTMLLineBreakNode();
    }

    public DivisionNode<HTMLRendererNode> newDivisionNode(RendererNode child) {
        return new HTMLDivisionNode((HTMLRendererNode)child);
    }

    public MarginNode<HTMLRendererNode> newMarginNode(RendererNode child, Margin margin) {
        return new HTMLMarginNode((HTMLRendererNode)child, margin);
    }

    public NoLineBreakNode<HTMLRendererNode> newNoLineBreakNode(RendererNode child) {
        return new HTMLNoLineBreakNode((HTMLRendererNode)child);
    }

    public StyleNode<HTMLRendererNode> newStyleNode(RendererNode child, RendererStyle style) {
        return new HTMLStyleNode((HTMLRendererNode)child, style);
    }

    public StyleNode<HTMLRendererNode> newStyleNode(RendererNode child, RendererStyle style, boolean asDiv) {
        return new HTMLStyleNode((HTMLRendererNode)child, style, asDiv);
    }

    public HyperLinkNode<HTMLRendererNode> newHyperLinkNode(RendererNode child, URI target) {
        return new HTMLHyperLinkNode((HTMLRendererNode)child, target);
    }

    @Override
    public RendererTheme getRendererTheme() {
        return this.theme;
    }
}

