/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.description.renderer;

import com.sap.jvm.profiling.presentation.description.renderer.TableNode;
import com.sap.jvm.profiling.presentation.description.renderer.TableStyle;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;

public class HTMLTableNode
extends TableNode<HTMLRendererNode>
implements HTMLRendererNode {
    private static int ID = 0;

    private static int genNewId() {
        return ID++;
    }

    public HTMLTableNode(String[] headings, double[] relativeWidths, boolean showBorder, boolean showGrid, int alignment, RendererNode[][] content, TableStyle style) {
        super(headings, relativeWidths, showBorder, showGrid, alignment, content, style);
    }

    @Override
    public boolean needsTextColor() {
        RendererNode[][] rendererNodeArray = this.getContent();
        int n = rendererNodeArray.length;
        for (int i = 0; i < n; ++i) {
            RendererNode[] row;
            for (RendererNode node : row = rendererNodeArray[i]) {
                if (!((HTMLRendererNode)node).needsTextColor()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void render(HTMLSink sink) {
        RendererNode[][] content;
        String tableID = "t_id_" + HTMLTableNode.genNewId();
        TableStyle tableStyle = this.getStyle();
        if (tableStyle != null) {
            sink.writeHTML(tableStyle.getHTMLTableStyle(tableID));
        }
        if (this.getAlignment() == 0) {
            sink.writeHTML("<center>");
        }
        if (this.showBorder()) {
            sink.writeHTML("\n<table border=\"1\" rules=\"groups\" id=\"" + tableID + "\" style=\"border: 2px solid; border-color:#000000; border-collapse:collapse;border-spacing:0px\">");
        } else {
            sink.writeHTML("\n<table id=\"" + tableID + "\" style=\"border: blank; border-collapse:collapse;border-spacing:0px\">");
        }
        String[] headings = this.getHeadings();
        double[] relativeWidths = this.getRelativeWidths();
        double widthsSum = 0.0;
        int nrOfColumns = -1;
        if (headings != null) {
            assert (nrOfColumns == -1 || nrOfColumns == headings.length);
            nrOfColumns = headings.length;
        }
        if (relativeWidths != null) {
            assert (nrOfColumns == -1 || nrOfColumns == relativeWidths.length);
            nrOfColumns = relativeWidths.length;
            for (double width : relativeWidths) {
                widthsSum += width;
            }
            sink.writeHTML("<colgroup>");
            for (double width : relativeWidths) {
                int percent = (int)(0.5 + 100.0 * width / widthsSum);
                sink.writeHTML("<col width=\"" + percent + "%\">");
            }
            sink.writeHTML("</colgroup>");
        }
        if (headings != null) {
            sink.writeHTML("\n<thead><tr>\n");
            for (int column = 0; column < nrOfColumns; ++column) {
                String thClass;
                String string = thClass = tableStyle == null ? "" : " class=\"" + tableStyle.getHeaderColumnAlignment(column).getValue() + "\"";
                if (this.showGrid()) {
                    sink.writeHTML("  <th" + thClass + " style=\"border: 1px solid; border-color:#a0a0a0\">");
                } else {
                    sink.writeHTML("  <th" + thClass + ">");
                }
                sink.writeText(headings[column]);
                sink.writeHTML("</th>\n");
            }
            sink.writeHTML("</tr></thead>");
        }
        if ((content = this.getContent()).length > 0) {
            assert (nrOfColumns == -1 || nrOfColumns == content[0].length);
            nrOfColumns = content[0].length;
            sink.writeHTML("\n<tbody>\n");
            for (int row = 0; row < content.length; ++row) {
                sink.writeHTML("  <tr>\n");
                for (int column = 0; column < nrOfColumns; ++column) {
                    String tdClass;
                    HTMLRendererNode node = (HTMLRendererNode)content[row][column];
                    String string = tdClass = tableStyle == null ? "" : " class=\"" + tableStyle.getColumnAlignment(column).getValue() + "\"";
                    if (this.showGrid()) {
                        sink.writeHTML("    <td" + tdClass + " style=\"border: 1px solid; border-color:#a0a0a0\">");
                    } else {
                        sink.writeHTML("    <td" + tdClass + ">");
                    }
                    node.render(sink);
                    sink.writeHTML("</td>\n");
                }
                sink.writeHTML("  </tr>\n");
            }
            sink.writeHTML("</tbody>\n");
        }
        sink.writeHTML("</table>\n");
        if (this.getAlignment() == 0) {
            sink.writeHTML("</center>\n");
        }
    }
}

