/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.excel;

import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelRendererNode;
import com.sap.jvm.tracing.Trace;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.util.IOUtils;

public class ExcelSink {
    public static final int ALIGN_LEFT = -1;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_IGNORE = Integer.MAX_VALUE;
    public static final int MIN_COL_WIDTH_FOR_PERCENTAGE = 2000;
    public HashSet<Integer> columnsWitchPercentage;
    public static final int MAX_COL_IDX = 7;
    private static final float PX_DEFAULT = 32.0f;
    private static final float PX_MODIFIED = 36.56f;
    private HSSFSheet sheet;
    private boolean includeImages;
    private HSSFRow currentRow;
    private HSSFCell currentCell;
    private int maxCol = 0;
    private HSSFPatriarch drawingPatriarch;
    private ArrayList<Integer>[] colorsStack;
    private short paletteIndex = (short)8;
    private HashSet<Short> customColorSet = new HashSet();
    private ArrayList<FontStyle> fontStack;
    private HSSFFont defaultFont;
    private HashMap<HSSFFont, FontMetrics> fontMetricsCache;
    private HSSFCellStyle styleLeftAligned;
    private HSSFCellStyle styleCenterAligned;
    private HSSFCellStyle styleRightAligned;
    private int currentCellAlignment;
    private HashMap<URI, Integer> loadedImages;
    private HashMap<Integer, Integer> imageWidthCache;
    private ArrayList<ImageInsert> imagesList;
    private ArrayList<NodeInsert> nodesList;
    private ArrayList<BarInsert> barsList;

    public ExcelSink(HSSFWorkbook workbook, String title, boolean includeImages) {
        this(workbook.createSheet(ExcelSink.sanitizeTitle(title)), includeImages);
    }

    private ExcelSink(HSSFSheet sheet, boolean includeImages) {
        this.sheet = sheet;
        this.includeImages = includeImages;
        this.drawingPatriarch = sheet.createDrawingPatriarch();
        this.colorsStack = new ArrayList[7];
        for (int i = 0; i < 7; ++i) {
            this.colorsStack[i] = new ArrayList();
        }
        this.fontStack = new ArrayList();
        this.defaultFont = sheet.getWorkbook().createFont();
        FontStyle defaultFontStyle = new FontStyle(this.defaultFont.getFontHeightInPoints(), this.defaultFont.getBold(), this.defaultFont.getItalic(), 0);
        this.fontStack.add(defaultFontStyle);
        this.fontMetricsCache = new HashMap();
        this.styleLeftAligned = sheet.getWorkbook().createCellStyle();
        this.styleLeftAligned.setAlignment(HorizontalAlignment.LEFT);
        this.styleCenterAligned = sheet.getWorkbook().createCellStyle();
        this.styleCenterAligned.setAlignment(HorizontalAlignment.CENTER);
        this.styleRightAligned = sheet.getWorkbook().createCellStyle();
        this.styleRightAligned.setAlignment(HorizontalAlignment.RIGHT);
        this.columnsWitchPercentage = new HashSet();
        this.loadedImages = new HashMap();
        this.imageWidthCache = new HashMap();
        this.imagesList = new ArrayList();
        this.nodesList = new ArrayList();
        this.barsList = new ArrayList();
    }

    public void startRow() {
        int lastRow = -1;
        if (this.currentRow != null) {
            lastRow = this.currentRow.getRowNum();
        }
        this.currentRow = this.sheet.createRow(lastRow + 1);
    }

    public void addColumnTitles(ArrayList<ExcelRendererNode> columnTitles) {
        int row = this.currentRow.getRowNum();
        int col = 0;
        for (ExcelRendererNode node : columnTitles) {
            this.nodesList.add(new NodeInsert(col, row, node));
            ++col;
        }
        this.maxCol = Math.max(col, this.maxCol);
    }

    public void fillCell(ExcelRendererNode node) {
        short newCellIdx = this.currentRow.getLastCellNum();
        if (newCellIdx < 0) {
            newCellIdx = 0;
        }
        this.maxCol = Math.max(newCellIdx, this.maxCol);
        this.currentCell = this.currentRow.createCell((int)newCellIdx);
        this.currentCellAlignment = node.getAlignment();
        node.render(this);
        switch (this.currentCellAlignment) {
            case 0: {
                this.currentCell.setCellStyle(this.styleCenterAligned);
                break;
            }
            case 1: {
                this.currentCell.setCellStyle(this.styleRightAligned);
                break;
            }
            default: {
                this.currentCell.setCellStyle(this.styleLeftAligned);
            }
        }
    }

    public void endTable() {
        int[] preferredColumnWidth = new int[this.maxCol];
        for (int col = 0; col < this.maxCol; ++col) {
            this.sheet.autoSizeColumn(col);
            preferredColumnWidth[col] = this.sheet.getColumnWidth(col);
        }
        for (NodeInsert node : this.nodesList) {
            node.insert();
        }
        this.nodesList.clear();
        for (int col = 0; col < this.maxCol; ++col) {
            this.sheet.autoSizeColumn(col);
            if (!this.columnsWitchPercentage.contains(col)) continue;
            int contentWidth = preferredColumnWidth[col];
            int colWidth = this.sheet.getColumnWidth(col);
            colWidth = Math.max(colWidth, contentWidth + 2000);
            this.sheet.setColumnWidth(col, colWidth);
            for (BarInsert bar : this.barsList) {
                if (bar.column != col) continue;
                bar.insert(contentWidth, colWidth);
            }
        }
        this.barsList.clear();
        for (ImageInsert image : this.imagesList) {
            image.place();
        }
        this.imagesList.clear();
    }

    public void pushBold(boolean bold) {
        FontStyle currentStyle = this.fontStack.get(this.fontStack.size() - 1);
        FontStyle newFont = new FontStyle(currentStyle.heightInPoints, bold, currentStyle.italic, currentStyle.color);
        this.fontStack.add(newFont);
    }

    public void pushItalic(boolean italic) {
        FontStyle currentStyle = this.fontStack.get(this.fontStack.size() - 1);
        FontStyle newFont = new FontStyle(currentStyle.heightInPoints, currentStyle.bold, italic, currentStyle.color);
        this.fontStack.add(newFont);
    }

    public void pushFontIncrease(int increment) {
        FontStyle currentStyle = this.fontStack.get(this.fontStack.size() - 1);
        FontStyle newFont = new FontStyle(currentStyle.heightInPoints + increment, currentStyle.bold, currentStyle.italic, currentStyle.color);
        this.fontStack.add(newFont);
    }

    public void pushFontColor(int color) {
        FontStyle currentStyle = this.fontStack.get(this.fontStack.size() - 1);
        FontStyle newFont = new FontStyle(currentStyle.heightInPoints, currentStyle.bold, currentStyle.italic, color);
        this.fontStack.add(newFont);
    }

    public void popFontStyleChange() {
        this.fontStack.remove(this.fontStack.size() - 1);
    }

    public void pushColors(int color1, int color2, int color3, int color4, int color5, int color6, int color7) {
        this.colorsStack[0].add(color1);
        this.colorsStack[1].add(color2);
        this.colorsStack[2].add(color3);
        this.colorsStack[3].add(color4);
        this.colorsStack[4].add(color5);
        this.colorsStack[5].add(color6);
        this.colorsStack[6].add(color7);
        this.pushFontColor(this.getColor(1));
    }

    public void popColors() {
        int lastIdx = this.colorsStack[0].size() - 1;
        this.colorsStack[0].remove(lastIdx);
        this.colorsStack[1].remove(lastIdx);
        this.colorsStack[2].remove(lastIdx);
        this.colorsStack[3].remove(lastIdx);
        this.colorsStack[4].remove(lastIdx);
        this.colorsStack[5].remove(lastIdx);
        this.colorsStack[6].remove(lastIdx);
        this.popFontStyleChange();
    }

    public void writeImage(URI image, String accessibleString) {
        if (!this.includeImages) {
            return;
        }
        ImageInsert newImage = this.addImage(image);
        if (newImage == null) {
            this.writeText(accessibleString);
            return;
        }
        int imageWidth = newImage.width;
        HSSFRichTextString text = this.currentCell.getRichStringCellValue();
        int cursorPosition = text == null ? 0 : text.length();
        int nrOfSpaces = 0;
        int remainingWidth = imageWidth;
        while (remainingWidth > 0) {
            this.writeText("  ");
            remainingWidth = imageWidth - this.getTextWidthInPx(this.currentCell.getRichStringCellValue(), cursorPosition, cursorPosition + (nrOfSpaces += 2));
        }
        newImage.position = cursorPosition + nrOfSpaces / 2;
    }

    public void writeOverlayImage(URI[] images, int[] indices, String accessibleString) {
        if (indices.length == 0 || !this.includeImages) {
            return;
        }
        int imageWidth = 0;
        ArrayList<ImageInsert> newImages = new ArrayList<ImageInsert>();
        for (int i : indices) {
            ImageInsert newImage = this.addImage(images[i]);
            if (newImage == null) continue;
            newImages.add(newImage);
            imageWidth = Math.max(imageWidth, newImage.width);
        }
        if (newImages.size() == 0) {
            this.writeText(accessibleString);
            return;
        }
        HSSFRichTextString text = this.currentCell.getRichStringCellValue();
        int cursorPosition = text == null ? 0 : text.length();
        int nrOfSpaces = 0;
        int remainingWidth = imageWidth;
        while (remainingWidth > 0) {
            this.writeText("  ");
            remainingWidth = imageWidth - this.getTextWidthInPx(this.currentCell.getRichStringCellValue(), cursorPosition, cursorPosition + (nrOfSpaces += 2));
        }
        int imagePosition = cursorPosition + nrOfSpaces / 2;
        for (ImageInsert newImage : newImages) {
            newImage.position = imagePosition;
        }
    }

    private ImageInsert addImage(URI image) {
        Integer imageIndex = this.loadedImages.get(image);
        if (imageIndex == null) {
            imageIndex = this.loadImage(image);
            if (imageIndex == null) {
                return null;
            }
            this.loadedImages.put(image, imageIndex);
        }
        ImageInsert newImage = new ImageInsert(imageIndex, this.currentCell.getColumnIndex(), this.currentCell.getRowIndex(), 0, this.currentCellAlignment);
        newImage.insert();
        this.imagesList.add(newImage);
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer loadImage(URI image) {
        Integer imageIndex;
        InputStream stream = null;
        try {
            URL imageUrl = image.toURL();
            String imagePath = imageUrl.getPath();
            String extension = imagePath.substring(imagePath.lastIndexOf(46)).toLowerCase();
            int pictureType = -1;
            if (".jpg".equals(extension) || ".jpeg".equals(extension)) {
                pictureType = 5;
            } else if (".gif".equals(extension)) {
                pictureType = 5;
            } else if (".png".equals(extension)) {
                pictureType = 6;
            } else {
                Trace.error(() -> "Unknown image format for URI " + image);
                Integer n = null;
                return n;
            }
            stream = imageUrl.openStream();
            byte[] imageData = IOUtils.toByteArray((InputStream)stream);
            imageIndex = this.sheet.getWorkbook().addPicture(imageData, pictureType);
        }
        catch (IOException e) {
            Trace.error((Throwable)e, () -> "Error loading image data from " + image);
            Integer n = null;
            return n;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageIndex;
    }

    public void writeDouble(double value) {
        this.currentCell.setCellValue(value);
    }

    public void writeText(String text) {
        if (text.length() == 0) {
            return;
        }
        HSSFFont currentFont = this.getFont();
        short fontIndex = (short)currentFont.getIndex();
        HSSFRichTextString oldText = this.currentCell.getRichStringCellValue();
        if (oldText == null) {
            oldText = new HSSFRichTextString("");
        }
        HSSFRichTextString newText = new HSSFRichTextString(oldText + text);
        int formattingRuns = oldText.numFormattingRuns();
        int startOfLastFormatting = oldText.toString().length();
        for (int i = 0; i < formattingRuns; ++i) {
            if (i == formattingRuns - 1 && oldText.getFontOfFormattingRun(i) == fontIndex) {
                startOfLastFormatting = oldText.getIndexOfFormattingRun(i);
                break;
            }
            newText.applyFont(oldText.getIndexOfFormattingRun(i), oldText.toString().length(), oldText.getFontOfFormattingRun(i));
        }
        newText.applyFont(startOfLastFormatting, newText.toString().length(), fontIndex);
        this.currentCell.setCellValue((RichTextString)newText);
    }

    public void addSpace(int width) {
        HSSFFont currentFont = this.getFont();
        int pixelsPerSpace = this.getTextWidthInPx(" ", currentFont);
        int spaces = (int)Math.ceil((double)width / (double)pixelsPerSpace);
        if (spaces > 0) {
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < spaces; ++i) {
                s.append(" ");
            }
            this.writeText(s.toString());
        }
    }

    public void drawPercentage(double percentage, int lineColor, int fillColor) {
        if (!this.includeImages) {
            return;
        }
        int column = this.currentCell.getColumnIndex();
        this.columnsWitchPercentage.add(column);
        this.currentCellAlignment = Integer.MAX_VALUE;
        this.barsList.add(new BarInsert(percentage, lineColor, fillColor, column, this.currentRow.getRowNum()));
    }

    public int getColor(int colIdx) {
        if (colIdx <= 0) {
            return 0;
        }
        if (colIdx > 7) {
            throw new IllegalArgumentException("Color index " + colIdx + " > " + 7);
        }
        ArrayList<Integer> stack = this.colorsStack[colIdx - 1];
        int color = stack.get(stack.size() - 1);
        if (color == -1) {
            return 0;
        }
        int blue = color & 0xFF;
        int green = color >> 8 & 0xFF;
        int red = color >> 16 & 0xFF;
        return blue << 16 | green << 8 | red;
    }

    private short getFontColorIndex(int color) {
        byte red = (byte)(color & 0xFF);
        byte green = (byte)(color >> 8 & 0xFF);
        byte blue = (byte)(color >> 16 & 0xFF);
        HSSFColor hssfColor = this.sheet.getWorkbook().getCustomPalette().findColor(red, green, blue);
        if (hssfColor == null) {
            short maxColors = 112;
            int index = -1;
            while (this.paletteIndex < maxColors) {
                if (!this.customColorSet.contains(this.paletteIndex)) {
                    index = this.paletteIndex;
                    break;
                }
                this.paletteIndex = (short)(this.paletteIndex + 1);
            }
            if (index != -1) {
                this.sheet.getWorkbook().getCustomPalette().setColorAtIndex(this.paletteIndex, red, green, blue);
                hssfColor = this.sheet.getWorkbook().getCustomPalette().getColor(this.paletteIndex);
            } else {
                hssfColor = this.sheet.getWorkbook().getCustomPalette().findSimilarColor(red, green, blue);
            }
        }
        this.customColorSet.add(hssfColor.getIndex());
        return hssfColor.getIndex();
    }

    private HSSFFont getFont() {
        FontStyle currentStyle = this.fontStack.get(this.fontStack.size() - 1);
        short fontColorIndex = this.getFontColorIndex(currentStyle.color);
        short fontHeight = (short)(currentStyle.heightInPoints * 20);
        HSSFFont font = this.sheet.getWorkbook().findFont(currentStyle.bold, fontColorIndex, fontHeight, this.defaultFont.getFontName(), currentStyle.italic, this.defaultFont.getStrikeout(), this.defaultFont.getTypeOffset(), this.defaultFont.getUnderline());
        if (font == null) {
            font = this.sheet.getWorkbook().createFont();
            font.setBold(currentStyle.bold);
            font.setColor(fontColorIndex);
            font.setFontHeight(fontHeight);
            font.setItalic(currentStyle.italic);
        }
        return font;
    }

    private float getPixelWidth(int column) {
        int def = this.sheet.getDefaultColumnWidth() * 256;
        int cw = this.sheet.getColumnWidth(column);
        return cw == def ? 32.0f : 36.56f;
    }

    private int getTextWidthInPx(HSSFRichTextString text, int start, int end) {
        assert (end >= start);
        if (end <= start) {
            return 0;
        }
        int result = 0;
        short currentFontIndex = text.getFontAtIndex(start);
        int lastFontChangePos = start;
        for (int position = start; position < end; ++position) {
            short newFont = text.getFontAtIndex(position);
            if (newFont == currentFontIndex && position != end - 1) continue;
            String substring = text.toString().substring(lastFontChangePos, position + 1);
            result += this.getTextWidthInPx(substring, this.sheet.getWorkbook().getFontAt((int)currentFontIndex));
        }
        return result;
    }

    private int getTextWidthInPx(String text, HSSFFont hssfFont) {
        FontMetrics metrics = this.fontMetricsCache.get(hssfFont);
        if (metrics == null) {
            int style;
            String name = hssfFont.getFontName();
            int size = hssfFont.getFontHeightInPoints() + 3;
            int n = style = hssfFont.getItalic() ? 2 : 0;
            if (hssfFont.getBold()) {
                style |= 1;
            }
            Font awtFont = new Font(name, style, size);
            Canvas component = new Canvas();
            metrics = component.getFontMetrics(awtFont);
            this.fontMetricsCache.put(hssfFont, metrics);
        }
        return metrics.stringWidth(text);
    }

    private static String sanitizeTitle(String title) {
        String sanitizedTitle = title;
        while (sanitizedTitle.startsWith("'")) {
            sanitizedTitle = sanitizedTitle.substring(1);
        }
        while (sanitizedTitle.endsWith("'")) {
            sanitizedTitle = sanitizedTitle.substring(0, sanitizedTitle.length() - 1);
        }
        sanitizedTitle = sanitizedTitle.replace('\u0000', ' ');
        sanitizedTitle = sanitizedTitle.replace('\u0003', ' ');
        sanitizedTitle = sanitizedTitle.replace(':', ' ');
        sanitizedTitle = sanitizedTitle.replace('\\', ' ');
        sanitizedTitle = sanitizedTitle.replace('*', ' ');
        sanitizedTitle = sanitizedTitle.replace('?', ' ');
        sanitizedTitle = sanitizedTitle.replace('/', ' ');
        sanitizedTitle = sanitizedTitle.replace('[', ' ');
        sanitizedTitle = sanitizedTitle.replace(']', ' ');
        return sanitizedTitle;
    }

    private class ImageInsert {
        int imageIndex;
        int column;
        int row;
        int position;
        int cellAlign;
        HSSFPicture picture;
        int width;

        public ImageInsert(int imageIndex, int column, int row, int position, int cellAlign) {
            this.imageIndex = imageIndex;
            this.column = column;
            this.row = row;
            this.position = position;
            this.cellAlign = cellAlign;
        }

        public void insert() {
            HSSFClientAnchor anchor = ExcelSink.this.sheet.getWorkbook().getCreationHelper().createClientAnchor();
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
            anchor.setCol1(this.column);
            anchor.setRow1(this.row);
            this.picture = ExcelSink.this.drawingPatriarch.createPicture((ClientAnchor)anchor, this.imageIndex);
            Integer cachedWidth = (Integer)ExcelSink.this.imageWidthCache.get(this.imageIndex);
            if (cachedWidth == null) {
                cachedWidth = this.picture.getImageDimension().width;
                ExcelSink.this.imageWidthCache.put(this.imageIndex, cachedWidth);
            }
            this.width = cachedWidth;
        }

        public void place() {
            int borderHeight;
            this.picture.resize();
            ClientAnchor anchor = (ClientAnchor)this.picture.getAnchor();
            int dyHeight = anchor.getDy2() - anchor.getDy1();
            if (anchor.getRow1() == anchor.getRow2() && (borderHeight = (255 - dyHeight) / 2) > 0) {
                anchor.setDy1(borderHeight);
            }
            int columWidth = ExcelSink.this.sheet.getColumnWidth(this.column);
            float pixelWidth = ExcelSink.this.getPixelWidth(this.column);
            HSSFRichTextString text = ExcelSink.this.sheet.getRow(this.row).getCell(this.column).getRichStringCellValue();
            int textLength = text == null ? 0 : text.length();
            float positionFromLeft = 0.0f;
            switch (this.cellAlign) {
                case 1: {
                    float pixelsFromRight = ExcelSink.this.getTextWidthInPx(text, this.position + 1, textLength);
                    positionFromLeft = (float)columWidth - (pixelsFromRight += (float)this.width / 2.0f) * pixelWidth;
                    break;
                }
                case 0: {
                    int leftWidth = ExcelSink.this.getTextWidthInPx(text, 0, this.position + 1);
                    int rightWidth = ExcelSink.this.getTextWidthInPx(text, this.position + 1, textLength);
                    float halfTextWidth = (float)(leftWidth + rightWidth) / 2.0f;
                    float distanceFromCenter = halfTextWidth - (float)leftWidth;
                    positionFromLeft = (float)columWidth / 2.0f - (distanceFromCenter += (float)this.width / 2.0f) * pixelWidth;
                    break;
                }
                default: {
                    float pixelsFromLeft = ExcelSink.this.getTextWidthInPx(text, 0, this.position + 1);
                    positionFromLeft = (pixelsFromLeft -= (float)this.width / 2.0f) * pixelWidth;
                }
            }
            int dx1 = (int)Math.round(1023.0 * (double)positionFromLeft / (double)columWidth);
            anchor.setDx1(dx1);
            this.picture.getPreferredSize();
        }
    }

    private class BarInsert {
        double percentage;
        int lineColor;
        int fillColor;
        int column;
        int row;

        public BarInsert(double percentage, int lineColor, int fillColor, int column, int row) {
            this.percentage = percentage;
            this.lineColor = lineColor;
            this.fillColor = fillColor;
            this.column = column;
            this.row = row;
        }

        public void insert(int contentWidth, int colWidth) {
            int startPos = (int)Math.round(1023.0 * (double)contentWidth / (double)colWidth) + 10;
            int availableWidth = 1003 - startPos;
            assert (availableWidth > 0);
            int barWidth = (int)Math.round((double)availableWidth * this.percentage);
            int dx1 = startPos;
            int dx2 = dx1 + barWidth;
            int dy1 = 50;
            int dy2 = 215;
            short col = (short)this.column;
            HSSFClientAnchor anchor = new HSSFClientAnchor(dx1, dy1, dx2, dy2, col, this.row, col, this.row);
            HSSFSimpleShape shape = ExcelSink.this.drawingPatriarch.createSimpleShape(anchor);
            shape.setShapeType(1);
            if (this.lineColor >= 0) {
                shape.setLineStyleColor(this.lineColor);
                shape.setLineStyle(0);
            } else {
                shape.setLineStyle(-1);
            }
            if (this.fillColor >= 0) {
                shape.setFillColor(this.fillColor);
                shape.setNoFill(false);
            } else {
                shape.setNoFill(true);
            }
        }
    }

    private class NodeInsert {
        int column;
        int row;
        ExcelRendererNode node;

        public NodeInsert(int column, int row, ExcelRendererNode node) {
            this.column = column;
            this.row = row;
            this.node = node;
        }

        public void insert() {
            ExcelSink.this.currentCell = ExcelSink.this.sheet.getRow(this.row).createCell(this.column);
            this.node.render(ExcelSink.this);
            switch (this.node.getAlignment()) {
                case 0: {
                    ExcelSink.this.currentCell.setCellStyle(ExcelSink.this.styleCenterAligned);
                    break;
                }
                case 1: {
                    ExcelSink.this.currentCell.setCellStyle(ExcelSink.this.styleRightAligned);
                    break;
                }
                default: {
                    ExcelSink.this.currentCell.setCellStyle(ExcelSink.this.styleLeftAligned);
                }
            }
        }
    }

    private class FontStyle {
        int heightInPoints;
        boolean bold;
        boolean italic;
        int color;

        public FontStyle(int height, boolean bold, boolean italic, int color) {
            this.heightInPoints = height;
            this.bold = bold;
            this.italic = italic;
            this.color = color;
        }
    }
}

