/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.excel;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelModelViewer;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelSink;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelRendererNode;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelTextNode;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.table.TableModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelTableExporter
implements ExcelModelExporter {
    private final TableModel model;
    private final boolean selectedOnly;

    public ExcelTableExporter(TableModel model, boolean selectedOnly) {
        this.model = model;
        this.selectedOnly = selectedOnly;
    }

    @Override
    public void writeExcel(File file, boolean includeImages, boolean includeColumnTitles, String title, ProgressReporter reporter) throws IOException {
        ExcelRendererNode node;
        ExcelModelViewer viewer = (ExcelModelViewer)this.model.getViewer();
        HSSFWorkbook wb = new HSSFWorkbook();
        ExcelSink sink = new ExcelSink(wb, title, includeImages);
        reporter.addWork(I18n._s((String)"Exporting table to Excel format ... (<%> %)"), (long)this.model.getNrOfItems());
        if (includeColumnTitles) {
            ArrayList<ExcelRendererNode> columnTitles = new ArrayList<ExcelRendererNode>();
            for (int column : this.model.getColumnOrder()) {
                if (!this.model.isColumnVisible(column)) continue;
                ExcelTextNode textNode = viewer.newTextNode(this.model.getColumnText(column));
                node = viewer.newChangeBoldNode(true, viewer.newFontSizeChangeNode(1, textNode));
                columnTitles.add(node);
            }
            sink.startRow();
            sink.addColumnTitles(columnTitles);
        }
        for (int i = 0; i < this.model.getNrOfItems(); ++i) {
            int itemId = this.model.getItemId(i);
            if (this.model.isSelected(itemId) || !this.selectedOnly) {
                sink.startRow();
                for (int column : this.model.getColumnOrder()) {
                    if (!this.model.isColumnVisible(column)) continue;
                    node = (ExcelRendererNode)this.model.getRendererForItem(itemId, column);
                    sink.fillCell(node);
                }
            }
            if (!reporter.reportNext()) break;
        }
        sink.endTable();
        if (reporter.isCancelled()) {
            return;
        }
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }
}

