/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.excel;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelDoubleNode;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelSink;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelRendererNode;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelTextNode;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphVirtualDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelTimeSeriesExporter
implements ExcelModelExporter {
    private final TimeSeriesModel model;

    public ExcelTimeSeriesExporter(TimeSeriesModel model) {
        this.model = model;
    }

    @Override
    public void writeExcel(File file, boolean includeImages, boolean includeColumnTitles, String title, ProgressReporter reporter) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        ExcelSink sink = new ExcelSink(wb, title, includeImages);
        ArrayList<Iterator<Value2D>> its = new ArrayList<Iterator<Value2D>>();
        ArrayList<ExcelRendererNode> titles = new ArrayList<ExcelRendererNode>();
        ArrayList<Double> scalesList = new ArrayList<Double>();
        long overallWork = 0L;
        TypedTimeSeriesModel typedModel = null;
        if (this.model instanceof TypedTimeSeriesModel) {
            typedModel = (TypedTimeSeriesModel)this.model;
        }
        for (int i = 0; i < this.model.getNrOfAreas(); ++i) {
            if (!this.model.isAreaVisible(i)) continue;
            for (int j = 0; j < this.model.getAreaSize(i); ++j) {
                String unit;
                Object graph = this.model.getGraph(i, j, 0L);
                if (!(graph instanceof LineGraphVirtualDataSet)) continue;
                LineGraphVirtualDataSet dataSet = (LineGraphVirtualDataSet)graph;
                titles.add(new ExcelTextNode(I18n._s((String)"Timestamp for {0} (seconds)", (Object[])new Object[]{this.model.getGraphName(i, j)})));
                overallWork += dataSet.getSize();
                its.add(dataSet.iterator());
                String string = unit = typedModel != null ? typedModel.getYAxisModel(i, j).getExportUnit() : "";
                if (unit.length() > 0) {
                    titles.add(new ExcelTextNode(I18n._s((String)"{0} ({1})", (Object[])new Object[]{this.model.getGraphName(i, j), unit})));
                } else {
                    titles.add(new ExcelTextNode(I18n._s((String)"{0}", (Object[])new Object[]{this.model.getGraphName(i, j)})));
                }
                if (typedModel != null) {
                    scalesList.add(typedModel.getYAxisModel(i, j).getScale());
                    continue;
                }
                scalesList.add(1.0);
            }
        }
        double[] scales = new double[scalesList.size()];
        for (int i = 0; i < scales.length; ++i) {
            scales[i] = (Double)scalesList.get(i);
        }
        reporter.setWork(I18n._s((String)"Exporting as excel spreadsheet... (<%> done)"), overallWork);
        boolean hasData = true;
        Value2D[] values = new Value2D[its.size()];
        if (includeColumnTitles) {
            sink.startRow();
            sink.addColumnTitles(titles);
        }
        while (hasData) {
            int i;
            hasData = false;
            for (i = 0; i < its.size(); ++i) {
                Iterator it = (Iterator)its.get(i);
                if (it.hasNext()) {
                    reporter.reportNextOrThrow();
                    hasData = true;
                    values[i] = (Value2D)((Iterator)its.get(i)).next();
                    continue;
                }
                values[i] = null;
            }
            if (!hasData) continue;
            sink.startRow();
            for (i = 0; i < its.size(); ++i) {
                Value2D value = values[i];
                if (value != null) {
                    sink.fillCell(new ExcelDoubleNode(value.x * 1.0E-6));
                    sink.fillCell(new ExcelDoubleNode(value.y * scales[i]));
                    hasData = true;
                    continue;
                }
                sink.fillCell(new ExcelTextNode(""));
                sink.fillCell(new ExcelTextNode(""));
            }
        }
        sink.endTable();
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }
}

