/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.excel;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelModelViewer;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelSink;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelChangeBoldNode;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelRendererNode;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelTextNode;
import com.sap.jvm.profiling.presentation.tree.TreeUtils;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelTreeExporter
implements ExcelModelExporter {
    private final TreeModel model;
    private final boolean selectedOnly;

    public ExcelTreeExporter(TreeModel model, boolean selectedOnly) {
        this.model = model;
        this.selectedOnly = selectedOnly;
    }

    @Override
    public void writeExcel(File file, boolean includeImages, boolean includeColumnTitles, String title, ProgressReporter reporter) throws IOException {
        ExcelModelViewer viewer = (ExcelModelViewer)this.model.getViewer();
        reporter.setMessage(I18n._s((String)"Exporting tree to Excel format ..."));
        HSSFWorkbook wb = new HSSFWorkbook();
        ExcelSink sink = new ExcelSink(wb, title, includeImages);
        if (includeColumnTitles) {
            ArrayList<ExcelRendererNode> columnTitles = new ArrayList<ExcelRendererNode>();
            for (int column : this.model.getColumnOrder()) {
                if (!this.model.isColumnVisible(column)) continue;
                ExcelTextNode textNode = viewer.newTextNode(this.model.getColumnText(column));
                ExcelChangeBoldNode node = viewer.newChangeBoldNode(true, viewer.newFontSizeChangeNode(1, textNode));
                columnTitles.add(node);
            }
            sink.startRow();
            sink.addColumnTitles(columnTitles);
        }
        TreeUtils.prepareForExport(this.model, this.selectedOnly);
        this.writeItems(this.model.getRootItems(), 0, sink, reporter);
        if (reporter.isCancelled()) {
            return;
        }
        sink.endTable();
        if (reporter.isCancelled()) {
            return;
        }
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    private void writeItems(TreeModelItem[] items, int indent, ExcelSink sink, ProgressReporter reporter) {
        ExcelModelViewer viewer = (ExcelModelViewer)this.model.getViewer();
        for (TreeModelItem item : items) {
            if (reporter.isCancelled()) {
                return;
            }
            if (!item.isSelected()) continue;
            sink.startRow();
            boolean isFirst = true;
            for (int column : this.model.getColumnOrder()) {
                ExcelRendererNode node;
                if (!this.model.isColumnVisible(column) || (node = (ExcelRendererNode)this.model.getRendererForItem(item, column)) == null) continue;
                if (isFirst && indent > 0) {
                    node = viewer.newMultiChildNode(viewer.newSpaceNode(indent * 16), node);
                }
                sink.fillCell(node);
                isFirst = false;
            }
            if (!item.isExpanded()) continue;
            this.writeItems(item.getSubsOrChildren(), indent + 1, sink, reporter);
        }
    }
}

