/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.excel;

import com.sap.jvm.profiling.presentation.impl.excel.ExcelDoubleNode;
import com.sap.jvm.profiling.presentation.impl.excel.ExcelSink;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelRendererNode;
import com.sap.jvm.profiling.presentation.impl.typed.excel.renderer.ExcelTextNode;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelValueSetExporter
implements ExcelModelExporter {
    private final ValueSetModel model;

    public ExcelValueSetExporter(ValueSetModel model) {
        this.model = model;
    }

    @Override
    public void writeExcel(File file, boolean includeImages, boolean includeColumnTitles, String title, ProgressReporter reporter) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        ExcelSink sink = new ExcelSink(wb, title, includeImages);
        if (includeColumnTitles) {
            ArrayList<ExcelRendererNode> titles = new ArrayList<ExcelRendererNode>();
            titles.add(new ExcelTextNode(""));
            for (int i = 0; i < this.model.getNrOfColumns(); ++i) {
                if (!this.model.isColumnVisible(i)) continue;
                titles.add(new ExcelTextNode(this.model.getColumnName(i)));
            }
            sink.startRow();
            sink.addColumnTitles(titles);
        }
        for (int i = 0; i < this.model.getNrOfRows(); ++i) {
            sink.startRow();
            sink.fillCell(new ExcelTextNode(this.model.getRowName(i).toString()));
            for (int j = 0; j < this.model.getNrOfColumns(); ++j) {
                if (!this.model.isColumnVisible(j)) continue;
                sink.fillCell(new ExcelDoubleNode(this.model.getValue(i, j)));
            }
        }
        sink.endTable();
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }
}

