/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.html;

import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLAlignNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLAlternateNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLAxisChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLBarChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLBarsChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLChangeBoldNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLChangeItalicsNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLColorNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLFixedWidthNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLFontSizeChangeNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLImageNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLLineChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLLinkNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLLongAndShortTextNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLMultiChildNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLNumberNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLOrderedMultiChildNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLOverlayImageNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLPercentageBarNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLPieChartNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLSeparatorNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLSpaceNode;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLTextNode;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.TaskManager;
import com.sap.jvm.profiling.viewer.TaskManagerAdaptor;
import com.sap.jvm.profiling.viewer.renderer.AxisChartNode;
import com.sap.jvm.profiling.viewer.renderer.LinkNode;
import com.sap.jvm.profiling.viewer.renderer.LinkType;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import java.net.URI;

public class HTMLModelViewer
implements ModelViewer {
    private final TaskManagerAdaptor taskManager = new TaskManagerAdaptor();

    @Override
    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public HTMLAlignNode newAlignNode(int alignment, RendererNode child) {
        return new HTMLAlignNode(alignment, (HTMLRendererNode)child);
    }

    public HTMLAlternateNode newAlternateNode(int selected, RendererNode[] children) {
        HTMLRendererNode[] copy = new HTMLRendererNode[children.length];
        System.arraycopy(children, 0, copy, 0, children.length);
        return new HTMLAlternateNode(selected, copy);
    }

    public HTMLChangeBoldNode newChangeBoldNode(boolean isBold, RendererNode child) {
        return new HTMLChangeBoldNode(isBold, (HTMLRendererNode)child);
    }

    public HTMLChangeItalicsNode newChangeItalicsNode(boolean isItalics, RendererNode child) {
        return new HTMLChangeItalicsNode(isItalics, (HTMLRendererNode)child);
    }

    public HTMLColorNode newColorNode(int rgb1, int rgb2, int rgb3, int rgb4, int rgb5, int rgb6, int rgb7, RendererNode child) {
        return new HTMLColorNode(rgb1, rgb2, rgb3, rgb4, rgb5, rgb6, rgb7, (HTMLRendererNode)child);
    }

    public HTMLFixedWidthNode newFixedWidthNode(int width, RendererNode child) {
        return new HTMLFixedWidthNode((HTMLRendererNode)child);
    }

    public HTMLFontSizeChangeNode newFontSizeChangeNode(int increase, RendererNode child) {
        return new HTMLFontSizeChangeNode(increase, (HTMLRendererNode)child);
    }

    @Override
    public HTMLImageNode newImageNode(URI image, String altText) {
        return new HTMLImageNode(image, altText);
    }

    @Override
    public HTMLOverlayImageNode newOverlayImageNode(URI[] images, int[] indices, String altText) {
        return new HTMLOverlayImageNode(images, indices, altText);
    }

    @Override
    public LinkNode<? extends RendererNode> newLinkNode(Object data, LinkType linkType, RendererNode child) {
        return new HTMLLinkNode((HTMLRendererNode)child);
    }

    @Override
    public HTMLLongAndShortTextNode newLongAndShortTextNode() {
        return new HTMLLongAndShortTextNode();
    }

    public HTMLMultiChildNode newMultiChildNode(RendererNode ... children) {
        HTMLRendererNode[] copy = new HTMLRendererNode[children.length];
        System.arraycopy(children, 0, copy, 0, children.length);
        return new HTMLMultiChildNode(copy);
    }

    @Override
    public HTMLNumberNode newNumberNode() {
        return new HTMLNumberNode();
    }

    public HTMLOrderedMultiChildNode newOrderedMultiChildNode(int[] order, RendererNode[] children) {
        HTMLRendererNode[] copy = new HTMLRendererNode[children.length];
        System.arraycopy(children, 0, copy, 0, children.length);
        return new HTMLOrderedMultiChildNode(order, copy);
    }

    @Override
    public HTMLPercentageBarNode newPercentageBarNode() {
        return new HTMLPercentageBarNode();
    }

    @Override
    public HTMLSeparatorNode newSeparatorNode() {
        return new HTMLSeparatorNode();
    }

    @Override
    public HTMLSpaceNode newSpaceNode(int width) {
        return new HTMLSpaceNode(width);
    }

    @Override
    public HTMLTextNode newTextNode(String text) {
        return new HTMLTextNode(text);
    }

    @Override
    public HTMLBarChartNode newBarChartNode() {
        return new HTMLBarChartNode(750, 500);
    }

    @Override
    public HTMLBarsChartNode newBarsChartNode() {
        return new HTMLBarsChartNode(750, 500);
    }

    @Override
    public HTMLLineChartNode newLineChartNode() {
        return new HTMLLineChartNode(750, 500);
    }

    @Override
    public HTMLPieChartNode newPieChartNode() {
        return new HTMLPieChartNode(750, 500);
    }

    @Override
    public AxisChartNode newAxisChartNode(int orientation, int labelPosition) {
        return new HTMLAxisChartNode(750, 500, orientation, labelPosition);
    }

    protected void startStatisticTable(HTMLSink sink, String[] headers, String[] headerToolTips) {
        sink.writeHTML("<table border=\"1\" style=\"border-collapse:collapse;border-style:solid;border-width:thin\">\n<tr>\n");
        assert (headerToolTips == null || headers.length == headerToolTips.length);
        for (int i = 0; i < headers.length; ++i) {
            if (headerToolTips != null && headerToolTips[i] != null && headerToolTips[i].length() > 0) {
                sink.writeHTML("  <th title=\"");
                sink.writeTitleText(headerToolTips[i]);
                sink.writeHTML("\">\n    ");
                sink.writeText(headers[i]);
                sink.writeHTML("\n  </th>\n");
                continue;
            }
            sink.writeHTML("  <th>\n    ");
            sink.writeText(headers[i]);
            sink.writeHTML("\n  </th>\n");
        }
        sink.writeHTML("</tr>\n");
    }

    protected void endStatisticTable(HTMLSink sink) {
        sink.writeHTML("</table>\n");
    }

    protected void writeStatisticTableCell(HTMLSink sink, HTMLRendererNode node, String toolTip, int indent) {
        int alignment;
        if (toolTip != null && toolTip.length() > 0) {
            sink.writeHTML("  <td title=\"");
            sink.writeTitleText(toolTip);
            sink.writeHTML("\"");
        } else {
            sink.writeHTML("  <td");
        }
        int n = alignment = node != null ? node.getAlignment() : -1;
        if (alignment < 0) {
            sink.writeHTML(">");
        } else {
            sink.writeHTML(" align=\"" + (alignment > 0 ? "right" : "center") + "\">");
        }
        if (indent > 0) {
            sink.addSpace(indent * 16);
        }
        if (node != null) {
            node.render(sink);
        }
        sink.writeHTML("</td>\n");
    }
}

