/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.html;

import com.sap.jvm.profiling.presentation.impl.description.HTMLDescriptionViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedReportModel;
import com.sap.jvm.profiling.presentation.typed.TypedReportProvider;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.util.pair.ObjectPair;
import java.io.File;
import java.io.IOException;

public class HTMLReportExporter
implements HTMLModelExporter {
    private final TypedReportModel model;
    private RendererThemeSpec themeSpec;

    public HTMLReportExporter(TypedReportModel model, RendererThemeSpec themeSpec) {
        this.model = model;
        this.themeSpec = themeSpec;
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void writeMHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames, reporter).saveAsMHTML(file, reporter);
    }

    @Override
    public void writeHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames, reporter).saveAsHTML(file, reporter);
    }

    @Override
    public void writeZipped(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames, reporter).saveAsZipFile(file, reporter);
    }

    private HTMLSink getSink(String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        HTMLSink sink = new HTMLSink("index.html", this.themeSpec.getOsTheme(), compressImageNames);
        RendererThemeImpl theme = new RendererThemeImpl(this.themeSpec);
        HTMLDescriptionViewer viewer = new HTMLDescriptionViewer(sink, theme);
        ResourceName name = this.model.getResourceName();
        TypedReportProvider provider = this.model.getProvider();
        String kind = "";
        viewer.addDescription(name, kind, (HTMLRendererNode)provider.getDescription(name, kind, viewer, reporter));
        while (viewer.hasUnknownLinks()) {
            ObjectPair<ResourceName, String> link = viewer.getUnknownLinks().iterator().next();
            ResourceName linkName = (ResourceName)link.getFirst();
            String linkKind = (String)link.getSecond();
            viewer.addDescription(linkName, linkKind, (HTMLRendererNode)provider.getDescription(linkName, linkKind, viewer, reporter));
        }
        return sink;
    }
}

