/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.html;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.description.renderer.Margin;
import com.sap.jvm.profiling.presentation.description.renderer.RendererStyle;
import com.sap.jvm.profiling.presentation.impl.description.HTMLJQueryProvider;
import com.sap.jvm.profiling.presentation.impl.html.Base64FilterOutputStream;
import com.sap.jvm.profiling.presentation.impl.html.QuotedPrintabeFilterOutputStream;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.tracing.Trace;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class HTMLSink {
    private static final String boundary = "----=_NextPart_000_0004_01C75035.7F6F2E30";
    private static final int IO_CHUNK_SIZE = 8192;
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private File currentTmpFile;
    private final HashMap<String, File> generatedHTML;
    private PrintWriter writer;
    private final String firstName;
    private String currentName;
    private final ArrayList<String> beginStack;
    private final ArrayList<String> endStack;
    private final ArrayList<Integer> colors1;
    private final ArrayList<Integer> colors2;
    private final ArrayList<Integer> colors3;
    private final ArrayList<Integer> colors4;
    private final ArrayList<Integer> colors5;
    private final ArrayList<Integer> colors6;
    private final ArrayList<Integer> colors7;
    private final HashMap<URI, String> images;
    private final HashMap<BufferedImage, String> bufferedImages;
    private final HashMap<String, String> tagMapping;
    private int nextImageIndex;
    private boolean inSelection;
    private ImageWriter pngWriter;
    private final boolean compressImageNames;
    private final OSThemeSpec osTheme;
    private int currentDefaultTextColor;
    private int toggleId;
    private int nextToggleId;
    private int divId;
    private int nextDivId;
    private File tmpDir;

    public HTMLSink(String htmlName, OSThemeSpec osTheme, boolean compressImageNames) {
        this(htmlName, osTheme, compressImageNames, null);
    }

    public HTMLSink(String htmlName, OSThemeSpec osTheme, boolean compressImageNames, File tempDir) {
        this.firstName = htmlName;
        this.compressImageNames = compressImageNames;
        this.beginStack = new ArrayList();
        this.endStack = new ArrayList();
        this.colors1 = new ArrayList();
        this.colors2 = new ArrayList();
        this.colors3 = new ArrayList();
        this.colors4 = new ArrayList();
        this.colors5 = new ArrayList();
        this.colors6 = new ArrayList();
        this.colors7 = new ArrayList();
        this.images = new HashMap();
        this.bufferedImages = new HashMap();
        this.tagMapping = new HashMap();
        this.generatedHTML = new HashMap();
        this.osTheme = osTheme;
        this.tmpDir = tempDir == null ? new File(System.getProperty("java.io.tmpdir")) : tempDir;
        this.newHTML(htmlName);
    }

    public void newHTML(String name) {
        File file = null;
        FilterOutputStream bos = null;
        OutputStreamWriter osw = null;
        try {
            file = File.createTempFile(name, null);
            bos = new BufferedOutputStream(new FileOutputStream(file));
            osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.error((Throwable)e, (String)"Could not get UTF-8 encoding");
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    Trace.error((Throwable)e, (String)"Could not close temporary file");
                }
            }
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Could not create temporary file");
        }
        this.writer = new PrintWriter(osw);
        this.beginStack.clear();
        this.endStack.clear();
        this.colors1.clear();
        this.colors2.clear();
        this.colors3.clear();
        this.colors4.clear();
        this.colors5.clear();
        this.colors6.clear();
        this.colors7.clear();
        this.currentDefaultTextColor = 0;
        this.currentName = name;
        this.toggleId = 0;
        this.nextToggleId = 0;
        this.divId = 0;
        this.nextDivId = 0;
        this.currentTmpFile = file;
    }

    public void finishHTML() {
        this.writer.close();
        this.generatedHTML.put(this.currentName, this.currentTmpFile);
        this.writer = null;
        this.currentTmpFile = null;
    }

    public void saveAsHTML(File file, ProgressReporter reporter) throws IOException {
        BufferedOutputStream bos;
        FileOutputStream fos;
        File imageFile;
        byte[] content;
        reporter.setMessage(I18n._s((String)"Writing the HTML file ... (<%> %)"));
        reporter.addToMaximumWork((long)(this.generatedHTML.size() + this.images.size() + this.bufferedImages.size()));
        File directory = file.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        for (Map.Entry<String, File> entry : this.generatedHTML.entrySet()) {
            File currFile = new File(directory, entry.getKey());
            if (entry.getKey().equals(this.firstName)) {
                currFile = file;
            }
            FileOutputStream fos2 = new FileOutputStream(currFile);
            BufferedOutputStream bos2 = new BufferedOutputStream(fos2);
            this.write((OutputStream)bos2, entry.getValue());
            bos2.close();
            entry.getValue().delete();
            if (reporter.reportNext()) continue;
            throw new OperationCanceledException();
        }
        for (Map.Entry<Object, Object> entry : this.images.entrySet()) {
            content = this.read((URI)entry.getKey());
            imageFile = new File(directory, (String)entry.getValue());
            fos = new FileOutputStream(imageFile);
            bos = new BufferedOutputStream(fos);
            reporter.setMessage(I18n._s((String)"Writing images ... (<%> %)"));
            this.write((OutputStream)bos, content);
            bos.close();
            if (reporter.reportNext()) continue;
            throw new OperationCanceledException();
        }
        for (Map.Entry<Object, Object> entry : this.bufferedImages.entrySet()) {
            content = this.toPNG((BufferedImage)entry.getKey());
            imageFile = new File(directory, (String)entry.getValue());
            fos = new FileOutputStream(imageFile);
            bos = new BufferedOutputStream(fos);
            reporter.setMessage(I18n._s((String)"Writing images ... (<%> %)"));
            this.write((OutputStream)bos, content);
            bos.close();
            if (reporter.reportNext()) continue;
            throw new OperationCanceledException();
        }
    }

    public void saveAsMHTML(File mhtmlFile, ProgressReporter reporter) throws IOException {
        Base64FilterOutputStream b64os;
        Object content;
        File directory = mhtmlFile.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(mhtmlFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintWriter mhtmlWriter = new PrintWriter(bos);
        mhtmlWriter.print("From: <Saved by SAP JVM Profiler>\r\n");
        mhtmlWriter.print("MIME-Version: 1.0\r\n");
        mhtmlWriter.print("Content-Type: multipart/related;\r\n");
        mhtmlWriter.print("\ttype=\"text/html\";\r\n");
        mhtmlWriter.print("\tboundary=\"");
        mhtmlWriter.print(boundary);
        mhtmlWriter.print("\"\r\n");
        mhtmlWriter.print("\r\n");
        mhtmlWriter.print("This is a multi-part message in MIME format.\r\n");
        mhtmlWriter.print("\r\n");
        String[] names = new String[this.generatedHTML.size()];
        names[0] = this.firstName;
        int index = 1;
        for (Map.Entry<String, File> entry : this.generatedHTML.entrySet()) {
            if (entry.getKey().equals(this.firstName)) continue;
            names[index] = entry.getKey();
            ++index;
        }
        reporter.setMessage(I18n._s((String)"Writing the HTML file ... (<%> %)"));
        reporter.addToMaximumWork((long)(this.generatedHTML.size() + this.images.size() + this.bufferedImages.size()));
        for (int i = 0; i < names.length; ++i) {
            mhtmlWriter.print("--");
            mhtmlWriter.print(boundary);
            mhtmlWriter.print("\r\n");
            mhtmlWriter.print("Content-Type: text/html;\r\n");
            mhtmlWriter.print("\tcharset=\"utf-8\"\r\n");
            mhtmlWriter.print("Content-Transfer-Encoding: quoted-printable\r\n");
            mhtmlWriter.print("Content-Location: " + names[i] + "\r\n\r\n");
            mhtmlWriter.flush();
            QuotedPrintabeFilterOutputStream quotedPrintabeFilterOutputStream = new QuotedPrintabeFilterOutputStream(bos);
            content = this.generatedHTML.get(names[i]);
            this.write((OutputStream)quotedPrintabeFilterOutputStream, (File)content);
            quotedPrintabeFilterOutputStream.flush();
            ((File)content).delete();
            if (reporter.reportNext()) continue;
            throw new OperationCanceledException();
        }
        for (Map.Entry<URI, String> entry : this.images.entrySet()) {
            content = this.read(entry.getKey());
            mhtmlWriter.print("\r\n");
            mhtmlWriter.print("--");
            mhtmlWriter.print(boundary);
            mhtmlWriter.print("\r\n");
            mhtmlWriter.print("Content-Type: image/gif\r\n");
            mhtmlWriter.print("Content-Transfer-Encoding: base64\r\n");
            mhtmlWriter.print("Content-Location: " + entry.getValue() + "\r\n");
            mhtmlWriter.print("\r\n");
            mhtmlWriter.flush();
            b64os = new Base64FilterOutputStream(bos);
            reporter.setMessage(I18n._s((String)"Writing images ... (<%> %)"));
            this.write((OutputStream)b64os, (byte[])content);
            b64os.close();
            if (reporter.reportNext()) continue;
            mhtmlWriter.close();
            throw new OperationCanceledException();
        }
        for (Map.Entry<Object, String> entry : this.bufferedImages.entrySet()) {
            content = this.toPNG((BufferedImage)entry.getKey());
            mhtmlWriter.print("\r\n");
            mhtmlWriter.print("--");
            mhtmlWriter.print(boundary);
            mhtmlWriter.print("\r\n");
            mhtmlWriter.print("Content-Type: image/png\r\n");
            mhtmlWriter.print("Content-Transfer-Encoding: base64\r\n");
            mhtmlWriter.print("Content-Location: " + entry.getValue() + "\r\n");
            mhtmlWriter.print("\r\n");
            mhtmlWriter.flush();
            b64os = new Base64FilterOutputStream(bos);
            reporter.setMessage(I18n._s((String)"Writing images ... (<%> %)"));
            this.write((OutputStream)b64os, (byte[])content);
            b64os.close();
            if (reporter.reportNext()) continue;
            throw new OperationCanceledException();
        }
        mhtmlWriter.print("\r\n");
        mhtmlWriter.print("--");
        mhtmlWriter.print(boundary);
        mhtmlWriter.print("--\r\n");
        mhtmlWriter.flush();
        mhtmlWriter.close();
    }

    public void saveAsZipFile(File zipFile, ProgressReporter reporter) throws IOException {
        CRC32 crc;
        ZipEntry zipEntry;
        byte[] content;
        File directory = zipFile.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        BufferedOutputStream bos = new BufferedOutputStream(zos);
        reporter.setMessage(I18n._s((String)"Writing the HTML file ... (<%> %)"));
        reporter.addToMaximumWork((long)(this.generatedHTML.size() + this.images.size() + this.bufferedImages.size()));
        for (Map.Entry<String, File> entry : this.generatedHTML.entrySet()) {
            zos.putNextEntry(new ZipEntry(entry.getKey()));
            this.write((OutputStream)bos, entry.getValue());
            bos.flush();
            zos.closeEntry();
            entry.getValue().delete();
            if (reporter.reportNext()) continue;
            throw new OperationCanceledException();
        }
        for (Map.Entry<Object, Object> entry : this.images.entrySet()) {
            content = this.read((URI)entry.getKey());
            zipEntry = new ZipEntry((String)entry.getValue());
            zipEntry.setMethod(0);
            zipEntry.setSize(content.length);
            zipEntry.setCompressedSize(content.length);
            crc = new CRC32();
            crc.update(content);
            zipEntry.setCrc(crc.getValue());
            zos.putNextEntry(zipEntry);
            reporter.setMessage(I18n._s((String)"Writing images ... (<%> %)"));
            this.write((OutputStream)bos, content);
            bos.flush();
            zos.closeEntry();
            if (reporter.reportNext()) continue;
            throw new OperationCanceledException();
        }
        for (Map.Entry<Object, Object> entry : this.bufferedImages.entrySet()) {
            content = this.toPNG((BufferedImage)entry.getKey());
            zipEntry = new ZipEntry((String)entry.getValue());
            zipEntry.setMethod(0);
            zipEntry.setSize(content.length);
            zipEntry.setCompressedSize(content.length);
            crc = new CRC32();
            crc.update(content);
            zipEntry.setCrc(crc.getValue());
            zos.putNextEntry(zipEntry);
            reporter.setMessage(I18n._s((String)"Writing images ... (<%> %)"));
            this.write((OutputStream)bos, content);
            bos.flush();
            zos.closeEntry();
            if (reporter.reportNext()) continue;
            throw new OperationCanceledException();
        }
        bos.close();
    }

    public void startLine(boolean isSelected) {
        this.inSelection = isSelected;
        if (isSelected) {
            this.writer.append("<tr class=sr>");
            this.currentDefaultTextColor = this.osTheme.getActiveSelectedTextColor();
        } else {
            this.writer.append("<tr class=ur>");
            this.currentDefaultTextColor = this.osTheme.getActiveNonSelectedTextColor();
        }
    }

    public void endLine() {
        this.writer.append("</tr>\n");
        this.currentDefaultTextColor = 0;
        this.inSelection = false;
    }

    public void writeHTML(String html) {
        this.writer.append(html);
    }

    public void writeTitleText(String titleText) {
        int pos = titleText.indexOf(10);
        int lastPos = 0;
        if (pos == -1) {
            this.writeText(titleText);
        } else {
            while (pos != -1) {
                this.writeHTML(" ");
                this.writeText(titleText.substring(lastPos, pos));
                this.writeHTML("\n");
                lastPos = pos + 1;
                pos = titleText.indexOf(10, lastPos);
            }
            this.writeHTML(" ");
            this.writeText(titleText.substring(lastPos));
        }
    }

    public void startHead(String title, boolean includeDefaultStyles, boolean includeDescriptionStyles, boolean includeJS) {
        this.writeHTML("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html>\n  <head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n    <title>\n");
        this.writeText("      " + title);
        this.writeHTML("\n    </title>\n");
        if (includeDefaultStyles) {
            this.writeHTML("    <style type=\"text/css\">\n      td {\n          padding-left:2px;\n          padding-right:2px;\n          white-space:nowrap}\n      tr.ur {\n             background-color:" + this.colorAsHex("#", this.osTheme.getActiveNonSelectedBackgroundColor(), ";") + "\n             text-color:" + this.colorAsHex("#", this.osTheme.getActiveNonSelectedTextColor(), "}") + "\n      tr.sr {\n             background-color:" + this.colorAsHex("#", this.osTheme.getActiveSelectedBackgroundColor(), ";") + "\n             text-color:" + this.colorAsHex("#", this.osTheme.getActiveSelectedTextColor(), "}") + "\n      table.t1 {\n                border-collapse:collapse;\n                border-spacing:0px}\n      table.s1 {\n                color:#fff;\n                border-collapse:collapse;\n                border-spacing:0px}\n      table.t2 {\n                overflow:hidden;\n                border-width:1px;\n                border-style:solid;\n                vertical-align:text-bottom;\n                border-collapse:collapse;\n                border-spacing:0px}\n    </style>\n");
        }
        if (includeDescriptionStyles) {
            this.writeHTML(RendererStyle.getStyle());
        }
        this.writeHTML("    <script language=\"javascript\" type=\"text/javascript\">\n      function collapse(a, b) {\n        var aStyle = document.getElementById(a).style;\n        var bStyle = document.getElementById(b).style;\n        if (aStyle.display == \"none\") {\n            aStyle.display = \"inline\";\n            bStyle.display = \"none\"\n        } else {\n            aStyle.display = \"none\";\n            bStyle.display = \"inline\"\n        }\n      }\n    </script>\n");
        if (includeJS) {
            HTMLJQueryProvider.writeHTMLHeaderImport(this);
            HTMLJQueryProvider.copyJquerySources(this.tmpDir);
        }
    }

    public void startBody() {
        this.writeHTML("\n  </head>\n<body>\n");
    }

    public void endBody() {
        this.writeHTML("</body>\n</html>");
    }

    public void pushFontIncrease(int increase) {
        if (increase == 0) {
            this.beginStack.add("");
            this.endStack.add("");
            return;
        }
        String start = "<span style=\"font-size:" + (100 + 10 * increase) + "%\">";
        String end = "</span>";
        this.writer.append(start);
        this.beginStack.add(start);
        this.endStack.add(end);
    }

    public void pushBold(boolean bold) {
        String start = "<span style=\"font-weight:" + (bold ? "bold" : "normal") + "\">";
        String end = "</span>";
        this.writer.append(start);
        this.beginStack.add(start);
        this.endStack.add(end);
    }

    public void pushItalic(boolean italic) {
        String start = "<span style=\"font-style:" + (italic ? "italic" : "normal") + "\">";
        String end = "</span>";
        this.writer.append(start);
        this.beginStack.add(start);
        this.endStack.add(end);
    }

    private void pushColor(int color) {
        if (color != -1 || color == this.currentDefaultTextColor) {
            String start = this.colorAsHex("<span style=\"color:#", color, "\">");
            String end = "</span>";
            this.writer.append(start);
            this.beginStack.add(start);
            this.endStack.add(end);
        } else {
            this.beginStack.add("");
            this.endStack.add("");
        }
    }

    public void pushColors(int color1, int color2, int color3, int color4, int color5, int color6, int color7, boolean setTextColor) {
        if (setTextColor) {
            int color = this.inSelection ? this.getRealColor(this.colors4, color4) : this.getRealColor(this.colors1, color1);
            if (color == 0 && this.colors1.size() == 0) {
                this.pushColor(-1);
            } else {
                this.pushColor(color);
            }
        } else {
            this.pushColor(-1);
        }
        this.colors1.add(color1);
        this.colors2.add(color2);
        this.colors3.add(color3);
        this.colors4.add(color4);
        this.colors5.add(color5);
        this.colors6.add(color6);
        this.colors7.add(color7);
    }

    private int getRealColor(ArrayList<Integer> colorStack, int color) {
        if (color == -1) {
            return -1;
        }
        if (colorStack.isEmpty()) {
            return color;
        }
        Integer lastColor = colorStack.get(colorStack.size() - 1);
        if (lastColor.equals(color)) {
            return -1;
        }
        return color;
    }

    public void popColors() {
        this.colors1.remove(this.colors1.size() - 1);
        this.colors2.remove(this.colors2.size() - 1);
        this.colors3.remove(this.colors3.size() - 1);
        this.colors4.remove(this.colors4.size() - 1);
        this.colors5.remove(this.colors5.size() - 1);
        this.colors6.remove(this.colors6.size() - 1);
        this.colors7.remove(this.colors7.size() - 1);
        this.pop();
    }

    public Integer getColor1() {
        return this.colors1.get(this.colors1.size() - 1);
    }

    public Integer getColor2() {
        return this.colors2.get(this.colors2.size() - 1);
    }

    public Integer getColor3() {
        return this.colors3.get(this.colors3.size() - 1);
    }

    public Integer getColor4() {
        return this.colors4.get(this.colors4.size() - 1);
    }

    public Integer getColor5() {
        return this.colors5.get(this.colors5.size() - 1);
    }

    public Integer getColor6() {
        return this.colors6.get(this.colors6.size() - 1);
    }

    public Integer getColor7() {
        return this.colors7.get(this.colors7.size() - 1);
    }

    public void pushMinWidth(int width, int alignment) {
        String start = alignment < 0 ? "<span style=\"width:" + width + "ex\">" : "<span style=\"width:" + width + "ex;text-align:" + (alignment > 0 ? "right" : "center") + "\">";
        String end = "</span>";
        this.writer.append(start);
        this.beginStack.add(start);
        this.endStack.add(end);
    }

    public void pushMargin(Margin margin) {
        String marginText = String.format("margin: %dpx %dpx %dpx %dpx", margin.getTop(), margin.getRight(), margin.getBottom(), margin.getLeft());
        String start = "<span style=\"display:block;" + marginText + "\">";
        String end = "</span>";
        this.writer.append(start);
        this.beginStack.add(start);
        this.endStack.add(end);
    }

    public void pushStyle(RendererStyle style) {
        String start = "<span class=\"" + (Object)((Object)style) + "\">";
        String end = "</span>";
        this.writer.append(start);
        this.beginStack.add(start);
        this.endStack.add(end);
    }

    public void pushDivStyle(RendererStyle style) {
        String start = "<div class=\"" + (Object)((Object)style) + "\">";
        String end = "</div>";
        this.writer.append(start);
        this.beginStack.add(start);
        this.endStack.add(end);
    }

    public void pop() {
        this.writer.append(this.endStack.get(this.endStack.size() - 1));
        this.endStack.remove(this.endStack.size() - 1);
        this.beginStack.remove(this.beginStack.size() - 1);
    }

    public void writeText(String text) {
        this.writer.append(HTMLSink.encode(text));
    }

    private String getNextShortImageName(String origName, String suffix) {
        if (this.compressImageNames) {
            String result = "z" + Integer.toString(this.nextImageIndex, 36) + suffix;
            ++this.nextImageIndex;
            return result;
        }
        return origName + suffix;
    }

    public void writeImage(URI image, String altTag) {
        String name = this.images.get(image);
        if (name == null) {
            String[] parts = image.toString().split("[/]");
            String fileName = parts[parts.length - 1];
            int index = fileName.lastIndexOf(46);
            name = this.getNextShortImageName(fileName.substring(0, index), fileName.substring(index));
            this.images.put(image, name);
        }
        this.writer.append("<img border=\"0\" src=\"");
        this.writer.append(name);
        if (altTag != null) {
            this.writer.append("\" alt=\"");
            this.writer.append(HTMLSink.encode(altTag));
        }
        this.writer.append("\"/>");
    }

    public void writeOverlayImage(URI[] overlyImages, int[] indices, String altTag) throws IOException {
        StringBuilder rawName = new StringBuilder();
        for (int i = 0; i < indices.length; ++i) {
            if (i > 0) {
                rawName.append('-');
            }
            String[] parts = overlyImages[indices[i]].toString().split("[/.]");
            String fileName = parts[parts.length - 2];
            rawName.append(fileName);
        }
        String tag = rawName.toString();
        if (this.writeImage(tag, null, altTag)) {
            return;
        }
        ImageReader pngReader = ImageIO.getImageReadersByFormatName("png").next();
        ImageReader gifReader = ImageIO.getImageReadersByFormatName("gif").next();
        BufferedImage[] overlayImages = new BufferedImage[overlyImages.length];
        for (int i = 0; i < overlyImages.length; ++i) {
            ImageReader reader;
            URL url = overlyImages[i].toURL();
            FileCacheImageInputStream is = new FileCacheImageInputStream(url.openStream(), this.tmpDir);
            if (url.getFile().endsWith(".png")) {
                reader = pngReader;
            } else {
                if (!url.getFile().endsWith(".gif")) continue;
                reader = gifReader;
            }
            reader.setInput(is);
            overlayImages[i] = reader.read(0);
            reader.reset();
        }
        int width = overlayImages[indices[0]].getWidth();
        int height = overlayImages[indices[0]].getHeight();
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        g.setBackground(new Color(0, 0, 0, 0));
        g.clearRect(0, 0, width, height);
        for (int index : indices) {
            g.drawImage(overlayImages[index], null, 0, 0);
        }
        bi.flush();
        this.writeImage(tag, bi, altTag);
    }

    public boolean writeImage(String tag, BufferedImage image, String altTag) {
        return this.writeImageWithAddition(tag, image, altTag, null);
    }

    public boolean writeImageWithAddition(String tag, BufferedImage image, String altTag, String addition) {
        String name;
        String realTag = tag;
        if (this.inSelection) {
            realTag = realTag + "-selected";
        }
        if (!this.tagMapping.containsKey(realTag)) {
            if (image == null) {
                return false;
            }
            name = this.getNextShortImageName(realTag, ".png");
            this.tagMapping.put(realTag, name);
            BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(image, null, 0, 0);
            bi.flush();
            this.bufferedImages.put(bi, name);
        } else {
            name = this.tagMapping.get(realTag);
        }
        this.writer.append("<img border=0 src=\"");
        this.writer.append(name);
        if (altTag != null) {
            this.writer.append("\" alt=\"");
            this.writer.append(HTMLSink.encode(altTag));
        }
        if (addition != null) {
            this.writer.append("\" " + addition + "/>");
        } else {
            this.writer.append("\"/>");
        }
        return true;
    }

    public void addSpace(int width) {
        String tag = "width-" + width;
        if (this.writeImage(tag, null, null)) {
            return;
        }
        BufferedImage bi = new BufferedImage(width, 1, 2);
        Graphics2D g = bi.createGraphics();
        g.setBackground(new Color(0, 0, 0, 0));
        g.clearRect(0, 0, width, 1);
        this.writeImage(tag, bi, null);
        bi.flush();
    }

    public int getToggleId() {
        return this.toggleId;
    }

    public void setToggleId(int toggleId) {
        this.toggleId = toggleId;
    }

    public int getNewToggleId() {
        ++this.nextToggleId;
        return this.nextToggleId;
    }

    public int getDivId() {
        return this.divId;
    }

    public void setDivId(int divId) {
        this.divId = divId;
    }

    public int getNewDivId() {
        ++this.nextDivId;
        return this.nextDivId;
    }

    public String colorAsHex(String prefix, int color, String suffix) {
        if (color == -1) {
            return "";
        }
        StringBuilder result = new StringBuilder(prefix);
        result.append(hexDigits[color >> 20 & 0xF]);
        result.append(hexDigits[color >> 16 & 0xF]);
        result.append(hexDigits[color >> 12 & 0xF]);
        result.append(hexDigits[color >> 8 & 0xF]);
        result.append(hexDigits[color >> 4 & 0xF]);
        result.append(hexDigits[color & 0xF]);
        result.append(suffix);
        return result.toString();
    }

    private static String encode(String text) {
        StringBuilder result = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    result.append("&#13;");
                    continue block7;
                }
                default: {
                    result.append(text.charAt(i));
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(OutputStream stream, File input) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(input));){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = is.read(buffer)) != -1) {
                stream.write(buffer, 0, length);
            }
        }
    }

    private void write(OutputStream stream, byte[] content) throws IOException {
        for (int off = 0; off < content.length; off += 8192) {
            stream.write(content, off, Math.min(8192, content.length - off));
        }
    }

    private byte[] read(URI uri) throws IOException {
        InputStream is = uri.toURL().openStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int read = 0;
        while ((read = bis.read(buffer, 0, 8192)) >= 0) {
            bos.write(buffer, 0, read);
        }
        bis.close();
        bos.close();
        return bos.toByteArray();
    }

    private byte[] toPNG(BufferedImage image) throws IOException {
        if (this.pngWriter == null) {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
            this.pngWriter = writers.next();
        }
        this.pngWriter.reset();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(bos);
        this.pngWriter.setOutput(ios);
        this.pngWriter.write(image);
        ios.close();
        return bos.toByteArray();
    }
}

