/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.html;

import com.sap.jvm.profiling.presentation.impl.description.renderer.HTMLNopNode;
import com.sap.jvm.profiling.presentation.impl.html.HTMLModelViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.util.IntArrayList;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.table.TableModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class HTMLTableExporter
implements HTMLModelExporter {
    private final TableModel model;
    private final OSThemeSpec osTheme;
    private final boolean selectedOnly;
    private final int[] columnsToSum;

    public HTMLTableExporter(TableModel model, OSThemeSpec osTheme, boolean selectedOnly, int[] columnsToSum) {
        this.model = model;
        this.osTheme = osTheme;
        this.selectedOnly = selectedOnly;
        this.columnsToSum = columnsToSum;
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void writeMHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsMHTML(file, reporter);
    }

    @Override
    public void writeHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsHTML(file, reporter);
    }

    @Override
    public void writeZipped(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsZipFile(file, reporter);
    }

    private HTMLSink getSink(String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames) {
        HTMLModelViewer viewer = (HTMLModelViewer)this.model.getViewer();
        HTMLSink sink = new HTMLSink("index.html", this.osTheme, compressImageNames);
        sink.startHead(title, true, false, false);
        sink.startBody();
        sink.writeHTML("<h1>\n  ");
        sink.writeText(title);
        sink.writeHTML("\n</h1>\n");
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> headerToolTips = new ArrayList<String>();
        for (int column : this.model.getColumnOrder()) {
            if (!this.model.isColumnVisible(column)) continue;
            headers.add(this.model.getColumnText(column));
            headerToolTips.add(this.model.getColumnToolTip(column));
        }
        viewer.startStatisticTable(sink, headers.toArray(new String[headers.size()]), includeToolTips ? headerToolTips.toArray(new String[headers.size()]) : null);
        IntArrayList notExported = new IntArrayList();
        for (int i = 0; i < this.model.getNrOfItems(); ++i) {
            int itemId = this.model.getItemId(i);
            if (this.model.isSelected(itemId) || !this.selectedOnly) {
                this.writeNotExported(sink, includeToolTips, notExported);
                sink.startLine(markSelected && this.model.isSelected(itemId));
                for (int column : this.model.getColumnOrder()) {
                    if (!this.model.isColumnVisible(column)) continue;
                    HTMLRendererNode node = (HTMLRendererNode)this.model.getRendererForItem(itemId, column);
                    String toolTip = this.model.getToolTip(itemId, column);
                    viewer.writeStatisticTableCell(sink, node, includeToolTips ? toolTip : null, 0);
                }
                sink.endLine();
                continue;
            }
            notExported.push(i);
        }
        this.writeNotExported(sink, includeToolTips, notExported);
        viewer.endStatisticTable(sink);
        sink.endBody();
        sink.finishHTML();
        return sink;
    }

    private void writeNotExported(HTMLSink sink, boolean includeToolTips, IntArrayList notExported) {
        if (notExported.size() == 0) {
            return;
        }
        HTMLModelViewer viewer = (HTMLModelViewer)this.model.getViewer();
        int[] itemIds = new int[notExported.size()];
        for (int i = 0; i < itemIds.length; ++i) {
            itemIds[i] = this.model.getItemId(notExported.get(i));
        }
        sink.startLine(false);
        for (int column : this.model.getColumnOrder()) {
            if (!this.model.isColumnVisible(column)) continue;
            boolean summed = false;
            for (int toSum : this.columnsToSum) {
                if (toSum != column) continue;
                HTMLRendererNode node = (HTMLRendererNode)this.model.getRendererForSkippedItems(itemIds, column);
                String toolTip = this.model.getToolTipForCombinedItems(itemIds, column);
                viewer.writeStatisticTableCell(sink, node, includeToolTips ? toolTip : null, 0);
                summed = true;
                break;
            }
            if (summed) continue;
            viewer.writeStatisticTableCell(sink, new HTMLNopNode(), null, 0);
        }
        sink.endLine();
        notExported.clear();
    }
}

