/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.html;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationTooltipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphAnnotationsImageFactory;
import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.awt.offscreen.renderer.GraphImageRenderer;
import com.sap.jvm.profiling.ui.graph.axes.LineGraphAxisCaptionProvider;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotation;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphAnnotationSet;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import com.sap.jvm.profiling.viewer.series.TimeSeriesRenderer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HTMLTimeSeriesExporter
implements HTMLModelExporter {
    private static final int INTER_GRAPH_SPACE = 20;
    private static final int LEGEND_IMAGE_SIZE = 14;
    private static final int GRAPH_AREA_WIDTH = 900;
    private static final int GRAPH_AREA_HEIGHT = 250;
    private final TimeSeriesModel model;
    private final OSThemeSpec osTheme;
    private Font font;
    private int leftAxisWidth = 40;
    private int rightAxisWidth = 40;
    private LineGraphAnnotationsImageFactory imgFacory;

    public HTMLTimeSeriesExporter(TimeSeriesModel model, OSThemeSpec osTheme, LineGraphAnnotationsImageFactory imgFactory) {
        this.model = model;
        this.osTheme = osTheme;
        this.imgFacory = imgFactory;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void writeMHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsMHTML(file, reporter);
    }

    @Override
    public void writeHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsHTML(file, reporter);
    }

    @Override
    public void writeZipped(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsZipFile(file, reporter);
    }

    private HTMLSink getSink(String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames) {
        HTMLSink sink = new HTMLSink("index.html", this.osTheme, compressImageNames);
        sink.startHead(title, true, false, false);
        sink.startBody();
        sink.writeHTML("<h1 style=\"text-align:center\">");
        sink.writeText(title);
        sink.writeHTML("</h1><table align=\"center\" cellspacing=\"10\">");
        int xOffset = 0;
        for (int areaIdx = 0; areaIdx < this.model.getNrOfAreas(); ++areaIdx) {
            if (!this.model.isAreaVisible(areaIdx)) continue;
            sink.writeHTML("<tr><td align=\"center\"><b style=\"font-size: 18\">");
            sink.writeText(this.model.getAreaName(areaIdx));
            sink.writeHTML("</b></td></tr>");
            this.renderGraphArea(sink, areaIdx, this.model.getGraphProvider(areaIdx, xOffset));
        }
        sink.writeHTML("</table>");
        sink.endBody();
        sink.finishHTML();
        return sink;
    }

    private void renderGraphArea(HTMLSink sink, int areaIdx, final TimeSeriesRenderer renderer) {
        Object[] yGraphs = renderer.getGraphsForY();
        Object[] y2Graphs = renderer.getGraphsForY2();
        if (yGraphs.length == 0) {
            return;
        }
        GraphImageRenderer imageRenderer = new GraphImageRenderer(900, 250, 1);
        GraphChartContainer container = imageRenderer.getChartsContainer();
        if (this.font != null) {
            imageRenderer.setFont(this.font);
        }
        final LineGraphChart chart = new LineGraphChart(container, true, true, false);
        chart.setRasterColor(Color.GRAY_90);
        container.enableLegend(false);
        chart.enableHorizontalSelection(true);
        chart.enableValueSelection(true);
        chart.setAutoQuickViewEnabling(true);
        chart.setHorizontalQuickViewSelection(true);
        chart.enableSecondaryYAxis(true);
        container.addChart(chart);
        chart.setXAxisCaptionProvider(renderer.getXAxisCaptionProvider());
        LineGraphAxisCaptionProvider yAxisCaptionProvider = renderer.getYAxisCaptionProvider();
        chart.setYAxisCaptionProvider(yAxisCaptionProvider);
        chart.setXRasterAdapter(renderer.getXAxisRasterAdapter());
        chart.setYRasterAdapter(renderer.getYAxisRasterAdapter());
        chart.getAxesModel().getYAxis().setPreferredDisplaySize(this.leftAxisWidth + 25);
        chart.addLineGraphSelectionToolTipProvider((LineGraphSelectionToolTipProvider)this.model.getToolTipProvider());
        chart.setAnnotationsImageFactory(this.imgFacory);
        for (Object graph : yGraphs) {
            if (graph instanceof LineGraphDataSet) {
                LineGraphDataSet dataSet = (LineGraphDataSet)graph;
                if (dataSet.isEmpty()) continue;
                chart.addGraph(dataSet, false);
                continue;
            }
            if (!(graph instanceof LineGraphAnnotationSet)) continue;
            chart.addAnnotationSet((LineGraphAnnotationSet)graph);
            LineGraphAnnotationSet set = (LineGraphAnnotationSet)graph;
            for (LineGraphAnnotation annotation : set.getAllAnnotations()) {
                Object data = annotation.getData();
                if (!(data instanceof URI)) continue;
                annotation.decorate(annotation.getColor(), annotation.getBorderColor());
            }
        }
        chart.setAnnotationTooltipProvider(new LineGraphAnnotationTooltipProvider(){

            @Override
            public String provideTooltip(List<LineGraphAnnotation> annotations) {
                if (annotations.size() > 1) {
                    HashMap<String, Integer> counts = new HashMap<String, Integer>();
                    for (LineGraphAnnotation a : annotations) {
                        String key = a.getMessage();
                        if (counts.containsKey(key)) {
                            counts.put(key, (Integer)counts.get(key) + 1);
                            continue;
                        }
                        counts.put(key, 1);
                    }
                    StringBuilder tooltip = new StringBuilder();
                    int count = counts.size();
                    for (Map.Entry e : counts.entrySet()) {
                        --count;
                        tooltip.append((String)e.getKey());
                        if ((Integer)e.getValue() > 1) {
                            tooltip.append(" (");
                            tooltip.append(e.getValue());
                            tooltip.append(')');
                        }
                        if (count <= 0) continue;
                        tooltip.append('\n');
                    }
                    return tooltip.toString();
                }
                if (annotations.size() > 0) {
                    return annotations.get(0).getMessage();
                }
                return null;
            }
        });
        LineGraphAxisCaptionProvider y2AxisCaptionProvider = renderer.getY2AxisCaptionProvider();
        chart.setSecondaryYAxisCaptionProvider(y2AxisCaptionProvider);
        chart.setSecYRasterAdapter(renderer.getY2AxisRasterAdapter());
        chart.getAxesModel().getYAxisSecondary().setPreferredDisplaySize(this.rightAxisWidth + 25);
        for (Object graph : y2Graphs) {
            LineGraphDataSet dataSet = (LineGraphDataSet)graph;
            if (dataSet.isEmpty()) continue;
            chart.addGraph(dataSet, true);
        }
        container.setInitializer(new Runnable(){

            @Override
            public void run() {
                long startX = Math.max(HTMLTimeSeriesExporter.this.model.getMinX(), HTMLTimeSeriesExporter.this.model.getVisibleRangeStart());
                long endX = Math.min(HTMLTimeSeriesExporter.this.model.getMaxX(), Math.max(startX, HTMLTimeSeriesExporter.this.model.getVisibleRangeEnd()));
                chart.adjustXAxis(startX, endX, false, true);
                chart.adjustYAxis(renderer.getYAxisRangeAdapter().adjustMin(0.0, 0.0), renderer.getYAxisRangeAdapter().adjustMax(0.0, 0.0) * 1.05, false);
                chart.adjustSecondaryYAxis(renderer.getY2AxisRangeAdapter().adjustMin(0.0, 0.0), renderer.getY2AxisRangeAdapter().adjustMax(0.0, 0.0) * 1.05, false);
                chart.closeValueBar();
                if (HTMLTimeSeriesExporter.this.model.hasSelection()) {
                    long start = HTMLTimeSeriesExporter.this.model.getSelectedStartTimeStamp();
                    long end = HTMLTimeSeriesExporter.this.model.getSelectedEndTimeStamp();
                    chart.selectHorizontal(start, end);
                }
            }
        });
        BufferedImage image = imageRenderer.getImage();
        sink.writeHTML("<tr><td align=\"center\">");
        sink.writeImageWithAddition("graph-area-" + areaIdx, image, null, " border=\"0\"");
        sink.writeHTML("</td><td nowrap valign=\"top\"><table cellspacing=\"20\"><tr><td><b style=\"font-size: 16\">&nbsp;</b></td></tr><tr><td style=\"line-height:1.5em\">");
        this.addLegend(sink, areaIdx, yGraphs, y2Graphs);
        sink.writeHTML("</td></tr></table></td></tr>");
    }

    private void addLegend(HTMLSink sink, int areaIdx, Object[] yGraphs, Object[] y2Graphs) {
        String imageTag;
        LineGraphDataSet dataSet;
        boolean first = true;
        int counter = 0;
        for (Object graph : yGraphs) {
            if (!(graph instanceof LineGraphDataSet) || (dataSet = (LineGraphDataSet)graph).isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                sink.writeHTML("<br>");
            }
            imageTag = "legend_img_" + areaIdx + "_" + counter;
            this.writeLegendItem(sink, (LineGraphDataSet)graph, imageTag);
            ++counter;
        }
        if (y2Graphs != null && y2Graphs.length > 0) {
            sink.writeHTML("<br><small>");
            sink.writeText(I18n._s((String)"Secondary y-axis:"));
            sink.writeHTML("</small>");
            for (Object graph : y2Graphs) {
                if (!(graph instanceof LineGraphDataSet) || (dataSet = (LineGraphDataSet)graph).isEmpty()) continue;
                sink.writeHTML("<br>");
                imageTag = "legend_img_" + areaIdx + "_" + counter;
                this.writeLegendItem(sink, (LineGraphDataSet)graph, imageTag);
                ++counter;
            }
        }
    }

    private void writeLegendItem(HTMLSink sink, LineGraphDataSet dataSet, String imageTag) {
        BufferedImage bi = new BufferedImage(14, 14, 1);
        Graphics2D g = bi.createGraphics();
        g.setBackground(new java.awt.Color(dataSet.getItemColor().rgb));
        g.clearRect(0, 0, 14, 14);
        g.setColor(new java.awt.Color(dataSet.getGraphColor().rgb));
        g.drawRect(0, 0, 13, 13);
        sink.writeImageWithAddition(imageTag, bi, null, "style=\"vertical-align:text-bottom\"");
        bi.flush();
        sink.addSpace(16);
        sink.writeHTML("<b>");
        sink.writeText(dataSet.getItemText());
        sink.writeHTML("</b>");
    }
}

