/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.html;

import com.sap.jvm.profiling.presentation.impl.html.HTMLModelViewer;
import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.presentation.impl.typed.TreeModelFullForwardIterator;
import com.sap.jvm.profiling.presentation.impl.typed.TreeModelItemImpl;
import com.sap.jvm.profiling.presentation.impl.typed.html.renderer.HTMLRendererNode;
import com.sap.jvm.profiling.presentation.tree.TreeUtils;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.util.IdentityHashSet;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class HTMLTreeExporter
implements HTMLModelExporter {
    private final TreeModel model;
    private final OSThemeSpec osTheme;
    private final boolean selectedOnly;

    public HTMLTreeExporter(TreeModel model, OSThemeSpec osTheme, boolean selectedOnly) {
        this.model = model;
        this.osTheme = osTheme;
        this.selectedOnly = selectedOnly;
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void writeHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsHTML(file, reporter);
    }

    @Override
    public void writeMHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsMHTML(file, reporter);
    }

    @Override
    public void writeZipped(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsZipFile(file, reporter);
    }

    private HTMLSink getSink(String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames) {
        HTMLModelViewer viewer = (HTMLModelViewer)this.model.getViewer();
        HTMLSink sink = new HTMLSink("index.html", this.osTheme, compressImageNames);
        sink.startHead(title, true, false, false);
        sink.startBody();
        sink.writeHTML("<h1>\n  ");
        sink.writeText(title);
        sink.writeHTML("\n</h1>\n");
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> headerToolTips = new ArrayList<String>();
        for (int column : this.model.getColumnOrder()) {
            if (!this.model.isColumnVisible(column)) continue;
            headers.add(this.model.getColumnText(column));
            headerToolTips.add(this.model.getColumnToolTip(column));
        }
        IdentityHashSet showSelected = new IdentityHashSet();
        if (markSelected) {
            TreeModelFullForwardIterator it = new TreeModelFullForwardIterator(this.model);
            while (it.hasNext()) {
                TreeModelItem item = it.next();
                if (!item.isSelected()) continue;
                showSelected.add((Object)item);
            }
        }
        TreeUtils.prepareForExport(this.model, this.selectedOnly);
        viewer.startStatisticTable(sink, headers.toArray(new String[headers.size()]), includeToolTips ? headerToolTips.toArray(new String[headers.size()]) : null);
        this.writeItems(this.model.getRootItems(), includeToolTips, showSelected, 0, sink);
        viewer.endStatisticTable(sink);
        sink.endBody();
        sink.finishHTML();
        return sink;
    }

    private void writeItems(TreeModelItem[] items, boolean includeToolTips, IdentityHashSet showSelected, int indent, HTMLSink sink) {
        HTMLModelViewer viewer = (HTMLModelViewer)this.model.getViewer();
        ArrayList<TreeModelItem> notExported = new ArrayList<TreeModelItem>();
        for (TreeModelItem item : items) {
            if (item.isSelected()) {
                this.writeNotExported(sink, includeToolTips, notExported, indent);
                sink.startLine(showSelected.contains((Object)item));
                boolean isFirst = true;
                for (int column : this.model.getColumnOrder()) {
                    if (!this.model.isColumnVisible(column)) continue;
                    HTMLRendererNode node = (HTMLRendererNode)this.model.getRendererForItem(item, column);
                    String toolTip = this.model.getToolTip(item, column);
                    viewer.writeStatisticTableCell(sink, node, includeToolTips ? toolTip : null, isFirst ? indent : 0);
                    isFirst = false;
                }
                sink.endLine();
                if (!item.isExpanded()) continue;
                this.writeItems(item.getSubsOrChildren(), includeToolTips, showSelected, indent + 1, sink);
                continue;
            }
            notExported.add(item);
        }
        this.writeNotExported(sink, includeToolTips, notExported, indent);
    }

    private void writeNotExported(HTMLSink sink, boolean includeToolTips, ArrayList<TreeModelItem> notExported, int indent) {
        if (notExported.size() == 0) {
            return;
        }
        HTMLModelViewer viewer = (HTMLModelViewer)this.model.getViewer();
        TreeModelItem[] items = notExported.toArray(new TreeModelItemImpl[notExported.size()]);
        sink.startLine(false);
        boolean isFirst = true;
        for (int column : this.model.getColumnOrder()) {
            if (!this.model.isColumnVisible(column)) continue;
            HTMLRendererNode node = (HTMLRendererNode)this.model.getRendererForSkippedItems(items, column);
            String toolTip = this.model.getToolTipForCombinedItems(items, column);
            viewer.writeStatisticTableCell(sink, node, includeToolTips ? toolTip : null, isFirst ? indent : 0);
            isFirst = false;
        }
        sink.endLine();
    }
}

