/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.html;

import com.sap.jvm.profiling.presentation.impl.html.HTMLSink;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.ui.graph.BarGraphChart;
import com.sap.jvm.profiling.ui.graph.BarGraphRenderer;
import com.sap.jvm.profiling.ui.graph.GraphChartContainer;
import com.sap.jvm.profiling.ui.graph.PieGraphChart;
import com.sap.jvm.profiling.ui.graph.awt.offscreen.renderer.GraphImageRenderer;
import com.sap.jvm.profiling.ui.graph.awt.renderer.Util;
import com.sap.jvm.profiling.ui.graph.geometry.Point2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.graph.BarGraphRendererProvider;
import com.sap.jvm.profiling.viewer.graph.GraphHelper;
import com.sap.jvm.profiling.viewer.graph.PieGraphRendererProvider;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;

public final class HTMLValueSetExporter
implements HTMLModelExporter {
    private static final int INTER_GRAPH_SPACE = 20;
    private static final int LEGEND_IMAGE_SIZE = 16;
    private static final int PIE_CHART_SIZE = 400;
    private static final int BAR_GRAPH_HEIGHT = 400;
    private static final int ONE_BAR_GRAPH_WIDTH = 120;
    private static final int ADDITIONAL_BAR_WIDTH = 30;
    private final OSThemeSpec osTheme;
    private final ValueSetModel model;
    private Font font;

    public HTMLValueSetExporter(ValueSetModel model, OSThemeSpec osTheme) {
        this.model = model;
        this.osTheme = osTheme;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void writeMHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsMHTML(file, reporter);
    }

    @Override
    public void writeHTML(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsHTML(file, reporter);
    }

    @Override
    public void writeZipped(File file, String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames, ProgressReporter reporter) throws IOException {
        this.getSink(title, includeToolTips, markSelected, compressImageNames).saveAsZipFile(file, reporter);
    }

    private HTMLSink getSink(String title, boolean includeToolTips, boolean markSelected, boolean compressImageNames) {
        HTMLSink sink = new HTMLSink("index.html", this.osTheme, compressImageNames);
        sink.startHead(title, false, false, false);
        sink.writeHTML("<style type=\"text/css\">");
        sink.writeHTML("body {font-family: Verdana, Tahoma, Arial, sans-serif}");
        sink.writeHTML("body {font-size: 12pt}");
        sink.writeHTML("table {font-size: 12pt}");
        sink.writeHTML("</style>");
        sink.startBody();
        if (this.model.getGraphType().getType() == 0) {
            this.renderPieGraph(sink, this.model.getPieBarGraphProvider(), markSelected);
        } else if (this.model.getGraphType().getType() == 2) {
            this.renderBarGraph(sink, this.model.getValueBarGraphProvider(), markSelected);
        } else if (this.model.getGraphType().getType() == 1) {
            this.renderBarGraph(sink, this.model.getPercentageBarGraphProvider(), markSelected);
        }
        sink.endBody();
        sink.finishHTML();
        return sink;
    }

    private void renderPieGraph(HTMLSink sink, PieGraphRendererProvider provider, boolean markSelected) {
        sink.writeHTML("<h1 style=\"text-align:center\">");
        sink.writeText(this.model.getTitle());
        sink.writeHTML("</h1><table align=\"center\" cellspacing=\"40\"><tr><td>");
        for (int column : GraphHelper.getVisibleColumns(this.model)) {
            sink.writeHTML("<div style=\"float:left\"><table cellspacing=\"20\"><tr><td align=\"center\"><b style=\"font-size: 18\">");
            GraphImageRenderer renderer = new GraphImageRenderer(400, 400, 1);
            if (this.font != null) {
                renderer.setFont(this.font);
            }
            GraphChartContainer container = renderer.getChartsContainer();
            GraphHelper helper = GraphHelper.create(provider, container, this.model, new int[]{column}, markSelected);
            PieGraphChart chart = (PieGraphChart)helper.getChart(0);
            sink.writeText(chart.getAllGraphs().get(0).getName());
            chart.getAllGraphs().get(0).changeName(null);
            container.enableLegend(false);
            sink.writeHTML("</b></td></tr><tr><td align=\"center\">");
            BufferedImage image = renderer.getImage();
            Rectangle rect = Util.getRectangle(chart.getPieGraph().getBounds(), 400);
            if (rect.x > 0) {
                --rect.x;
                ++rect.width;
            }
            if (rect.y > 0) {
                ++rect.height;
            }
            int xOffs = rect.x - chart.getGraphArea().x;
            int yOffs = --rect.y;
            BufferedImage cropped = image.getSubimage(rect.x, rect.y, rect.width + 1, rect.height + 1);
            sink.writeImageWithAddition("pie-chart-" + column, cropped, null, " border=\"0\" usemap=\"#ChartToolTips" + column + "\"");
            sink.writeHTML("<map name=\"ChartToolTips" + column + "\">\n");
            for (int row = 0; row < this.model.getNrOfRows(); ++row) {
                sink.writeHTML("<area shape=\"poly\" coords=\"");
                Point2D[] path = chart.getPieGraph().getArc(row).asPath();
                for (int j = 0; j < path.length; ++j) {
                    if (j > 0) {
                        sink.writeHTML(",");
                    }
                    int x = path[j].x - xOffs;
                    int y = 400 - path[j].y - yOffs;
                    sink.writeHTML(x + "," + y);
                }
                sink.writeHTML("\" title=\"");
                sink.writeTitleText(this.model.getToolTip(row, column));
                sink.writeHTML("\">");
            }
            sink.writeHTML("</map></td></tr></table></div>");
        }
        sink.writeHTML("</td><td nowrap valign=\"top\"><table cellspacing=\"20\"><tr><td><b style=\"font-size: 18\">&nbsp;</b></td></tr><tr><td style=\"line-height:1.5em\">");
        this.addLegend(sink);
        sink.writeHTML("</td></tr></table></td></tr></table>");
    }

    private void renderBarGraph(HTMLSink sink, BarGraphRendererProvider provider, boolean markSelected) {
        sink.writeHTML("<h1 style=\"text-align:center\">");
        sink.writeText(this.model.getTitle());
        sink.writeHTML("</h1><table align=\"center\" cellspacing=\"40\"><tr><td>");
        for (int column : GraphHelper.getVisibleColumns(this.model)) {
            sink.writeHTML("<div style=\"float:left\"><table cellspacing=\"20\"><tr><td align=\"center\"><b style=\"font-size: 18\">");
            GraphImageRenderer renderer = new GraphImageRenderer(120 + this.model.getNrOfRows() * 30, 400, 1);
            if (this.font != null) {
                renderer.setFont(this.font);
            }
            GraphChartContainer container = renderer.getChartsContainer();
            GraphHelper helper = GraphHelper.create(provider, container, this.model, new int[]{column}, true, markSelected);
            BarGraphChart chart = (BarGraphChart)helper.getChart(0);
            chart.setRasterColor(Color.GRAY_90);
            container.enableLegend(false);
            BufferedImage image = renderer.getImage();
            sink.writeText(helper.getTitle(0));
            sink.writeHTML("</b></td></tr><tr><td align=\"center\">");
            sink.writeImageWithAddition("bar-chart-" + column, image, null, " border=\"0\" usemap=\"#ChartToolTips" + column + "\"");
            sink.writeHTML("<map name=\"ChartToolTips" + column + "\">\n");
            List<BarGraphRenderer.DisplayedBar> bars = chart.getAllVisibleBars();
            for (int row = 0; row < bars.size(); ++row) {
                sink.writeHTML("<area shape=\"poly\" coords=\"");
                com.sap.jvm.profiling.ui.graph.geometry.Rectangle path = bars.get(row).getViewRect();
                int x1 = path.x;
                int x2 = x1 + path.width;
                int y1 = 400 - path.y_end;
                int y2 = y1 - path.height;
                sink.writeHTML(x1 + "," + y1 + "," + x2 + "," + y1 + "," + x2 + "," + y2 + "," + x1 + "," + y2);
                sink.writeHTML("\" title=\"");
                sink.writeTitleText(this.model.getToolTip(row, column));
                sink.writeHTML("\">");
            }
            sink.writeHTML("</map></td></tr></table></div>");
        }
        sink.writeHTML("</td><td nowrap valign=\"top\"><table cellspacing=\"20\"><tr><td><b style=\"font-size: 18\">&nbsp;</b></td></tr><tr><td style=\"line-height:1.5em\">");
        this.addLegend(sink);
        sink.writeHTML("</td></tr></table></td></tr></table>");
    }

    private void addLegend(HTMLSink sink) {
        for (int i = 0; i < this.model.getNrOfRows(); ++i) {
            if (i > 0) {
                sink.writeHTML("<br>");
            }
            BufferedImage bi = new BufferedImage(16, 16, 1);
            Graphics2D g = bi.createGraphics();
            g.setBackground(new java.awt.Color(this.model.getRowColor(i)));
            g.clearRect(0, 0, 16, 16);
            g.setColor(java.awt.Color.BLACK);
            g.drawRect(0, 0, 15, 15);
            sink.writeImageWithAddition("legend image" + i, bi, null, "style=\"vertical-align:text-bottom\"");
            bi.flush();
            sink.addSpace(16);
            sink.writeHTML("<b>");
            sink.writeText(this.model.getRowName(i));
            sink.writeHTML("</b>");
        }
    }
}

