/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource;

import com.sap.jvm.profiling.presentation.impl.resource.context.AllocatedClassesSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.AllocationTypeSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.AnnotationSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.ClassFilterContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.ClassSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.ElementContext;
import com.sap.jvm.profiling.presentation.impl.resource.context.EntitySelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.FileIdSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.FileNameSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.FilterEntityPathSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.GcEventTypeSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.GcFilterPromotionFailuresContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.GcIdSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.GcTimeSeriesSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.InlineContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.InvocationIdSelectionContexCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.LengthRangeSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.LengthSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.LoaderSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.MethodFilterContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.MethodParameterSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.MethodPathSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.MethodSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.MonitorSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.NetworkHostSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.NetworkServiceSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.NullCreationContext;
import com.sap.jvm.profiling.presentation.impl.resource.context.PackageSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.ParameterValueSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.ReentrantLockSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.RemoveInlineContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.RootContext;
import com.sap.jvm.profiling.presentation.impl.resource.context.RunningTypeSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.SocketConnectionSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.SocketIdSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.SynchronizationEventSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.ThreadIdSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.ThreadNameSelectionContextCreator;
import com.sap.jvm.profiling.presentation.impl.resource.context.ThreadRunContextCreator;
import com.sap.jvm.profiling.presentation.impl.typed.TypedModelRendererImpl;
import com.sap.jvm.profiling.presentation.impl.typed.renderer.RendererThemeImpl;
import com.sap.jvm.profiling.presentation.resource.CreationContext;
import com.sap.jvm.profiling.presentation.resource.CreationContextProvider;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreatorFactory;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.viewer.ModelViewer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public final class CreationContextProviderImpl
implements CreationContextProvider {
    private static final ArrayList<ElementContextCreatorFactory> factories = new ArrayList();
    private final HashMap<Class<?>, ElementContextCreator> elementCreators;

    public static void registerElementContextCreatorFactory(ElementContextCreatorFactory factory) {
        factories.add(factory);
    }

    public CreationContextProviderImpl(ModelViewer viewer, RendererThemeSpec spec) throws IOException {
        RendererTheme theme = new TypedModelRendererImpl(new RendererThemeImpl(spec)).getForViewer(viewer, spec).getTheme();
        this.elementCreators = new HashMap();
        this.addElementCreator(new MethodSelectionContextCreator(viewer, theme));
        this.addElementCreator(new ClassSelectionContextCreator(viewer, theme));
        this.addElementCreator(new LoaderSelectionContextCreator(viewer, theme));
        this.addElementCreator(new PackageSelectionContextCreator(viewer, theme));
        this.addElementCreator(new AllocatedClassesSelectionContextCreator(viewer, theme));
        this.addElementCreator(new LengthSelectionContextCreator(viewer, theme));
        this.addElementCreator(new MethodFilterContextCreator(viewer, theme));
        this.addElementCreator(new ClassFilterContextCreator(viewer, theme));
        this.addElementCreator(new AnnotationSelectionContextCreator(viewer, theme));
        this.addElementCreator(new ThreadNameSelectionContextCreator(viewer, theme));
        this.addElementCreator(new ThreadIdSelectionContextCreator(viewer, theme));
        this.addElementCreator(new MethodPathSelectionContextCreator(viewer, theme));
        this.addElementCreator(new InlineContextCreator(viewer, theme));
        this.addElementCreator(new EntitySelectionContextCreator(viewer, theme));
        this.addElementCreator(new FilterEntityPathSelectionContextCreator(viewer, theme));
        this.addElementCreator(new RemoveInlineContextCreator(viewer, theme));
        this.addElementCreator(new MethodParameterSelectionContextCreator(viewer, theme));
        this.addElementCreator(new ParameterValueSelectionContextCreator(viewer, theme));
        this.addElementCreator(new InvocationIdSelectionContexCreator(viewer, theme));
        this.addElementCreator(new LengthRangeSelectionContextCreator(viewer, theme));
        this.addElementCreator(new MonitorSelectionContextCreator(viewer, theme));
        this.addElementCreator(new ReentrantLockSelectionContextCreator(viewer, theme));
        this.addElementCreator(new SynchronizationEventSelectionContextCreator(viewer, theme));
        this.addElementCreator(new FileNameSelectionContextCreator(viewer, theme));
        this.addElementCreator(new FileIdSelectionContextCreator(viewer, theme));
        this.addElementCreator(new GcEventTypeSelectionContextCreator(viewer, theme));
        this.addElementCreator(new GcIdSelectionContextCreator(viewer, theme));
        this.addElementCreator(new GcFilterPromotionFailuresContextCreator(viewer, theme));
        this.addElementCreator(new GcTimeSeriesSelectionContextCreator(viewer, theme));
        this.addElementCreator(new SocketIdSelectionContextCreator(viewer, theme));
        this.addElementCreator(new SocketConnectionSelectionContextCreator(viewer, theme));
        this.addElementCreator(new NetworkServiceSelectionContextCreator(viewer, theme));
        this.addElementCreator(new NetworkHostSelectionContextCreator(viewer, theme));
        this.addElementCreator(new RunningTypeSelectionContextCreator(viewer, theme));
        this.addElementCreator(new AllocationTypeSelectionContextCreator(viewer, theme));
        this.addElementCreator(new ThreadRunContextCreator(viewer, theme));
        for (ElementContextCreatorFactory factory : factories) {
            this.addElementCreator(factory.create(viewer, theme));
        }
    }

    @Override
    public CreationContext get(Snapshot snapshot, ResourceName sourceName, ResourceName destName) {
        if (sourceName == null) {
            return new RootContext(snapshot);
        }
        ResourceNameElement[] sourceElements = sourceName.getElements();
        ResourceNameElement[] destElements = destName.getElements();
        for (int i = 0; i < destElements.length; ++i) {
            if (i < sourceElements.length && destElements[i].equals((Object)sourceElements[i])) continue;
            for (int j = i; j < destElements.length; ++j) {
                ElementContextCreator creator = this.elementCreators.get(destElements[j].getClass());
                if (creator == null) continue;
                return new ElementContext(creator, destElements[j]);
            }
            return new NullCreationContext();
        }
        return new NullCreationContext();
    }

    private void addElementCreator(ElementContextCreator creator) {
        for (Class<?> clazz : creator.getSupportedElements()) {
            this.elementCreators.put(clazz, creator);
        }
    }
}

