/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource;

import com.sap.jvm.profiling.presentation.typed.ProviderResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceHandler;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.util.AccessibleObjectWrapper;
import com.sap.jvm.profiling.util.CtorWrapper;
import java.io.IOException;

public class ProviderResourceHandler
implements ResourceHandler {
    private static AccessibleObjectWrapper.SetAccessibleHook sah = o -> {
        if (!o.isAccessible()) {
            o.setAccessible(true);
        }
    };
    private final CtorWrapper constructor;
    private final boolean ctorHasReporterArg;
    private final ResourceNameElement element;

    public ProviderResourceHandler(ResourceNameElement element, Class<? extends ProviderResource> resource) {
        this(resource, element, false);
    }

    public ProviderResourceHandler(Class<? extends ProviderResource> resource, ResourceNameElement element, boolean hasProgressReporter) {
        this.element = element;
        this.ctorHasReporterArg = hasProgressReporter;
        this.constructor = hasProgressReporter ? new CtorWrapper(resource, sah, new Class[]{ResourceName.class, ProgressReporter.class}) : new CtorWrapper(resource, sah, new Class[]{ResourceName.class});
    }

    public boolean canHandle(ResourceName name) {
        return name.endsWithType(this.element);
    }

    public Resource create(ResourceName name, ProgressReporter reporter) throws IOException {
        if (this.ctorHasReporterArg) {
            return (Resource)this.constructor.newInstanceWithIOException(new Object[]{name, reporter});
        }
        return (Resource)this.constructor.newInstanceWithIOException(new Object[]{name});
    }

    public Resource read(ResourceName name, ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0, 0);
        return this.create(name, reporter);
    }

    public void write(ResourceName name, Resource resource, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
    }

    public long calculateWriteWork(ResourceName name, Resource resource) {
        return 0L;
    }
}

