/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocatedObjectByArea;
import com.sap.jvm.profiling.snapshot.filter.AllocationAreaFilter;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class AllocationTypeSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedAllocationTypes";
    private TextNode idNode;
    private RendererNode root;

    public AllocationTypeSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.idNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.idNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterAllocatedObjectByArea impl = (FilterAllocatedObjectByArea)element;
        AllocationAreaFilter filter = impl.getFilter();
        String result = filter.matchesHeapAllocations() && filter.matchesStackAllocations() ? I18n._s((String)"all allocations") : (filter.matchesHeapAllocations() ? I18n._s((String)"heap allocations") : (filter.matchesStackAllocations() ? I18n._s((String)"stack allocations") : I18n._s((String)"no allocations")));
        String text = result.toString();
        this.idNode.setText(text);
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterAllocatedObjectByArea impl = (FilterAllocatedObjectByArea)element;
        AllocationAreaFilter filter = impl.getFilter();
        String result = filter.matchesHeapAllocations() && filter.matchesStackAllocations() ? I18n._s((String)"includes heap and stack allocations") : (filter.matchesHeapAllocations() ? I18n._s((String)"includes only heap allocations") : (filter.matchesStackAllocations() ? I18n._s((String)"includes only stack allocations") : I18n._s((String)"includes no allocations")));
        return result;
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterAllocatedObjectByArea.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return this.createRendererNode(element, session).asString();
    }
}

