/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadAnnotationContext;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.AbstractFilterByThreadAnnotation;
import com.sap.jvm.profiling.snapshot.elements.ThreadElements;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.util.HashMap;

public final class AnnotationSelectionContextCreator
implements ElementContextCreator {
    private static final String USER_TAG = "context.selectedUsers";
    private static final String APPLICATION_TAG = "context.selectedApplication";
    private static final String SESSION_TAG = "context.selectedSession";
    private static final String REQUEST_TAG = "context.selectedRequest";
    private static final String TENANT_TAG = "context.selectedTenant";
    private static final int MAX_RENDER_ANNOTATION = 4;
    private static final int MAX_ANNOTATION_NAME = 15;
    private static final int MAX_TOOL_TIP_ANNOTATION = 20;
    private final TextNode annotationNode;
    private final RendererNode userRoot;
    private final RendererNode applicationRoot;
    private final RendererNode sessionRoot;
    private final RendererNode requestRoot;
    private final RendererNode tenantRoot;
    private final HashMap<String, RendererNode> rendererTypes;

    public AnnotationSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.annotationNode = viewer.newTextNode(null);
        this.userRoot = theme.decorate(USER_TAG, viewer, this.annotationNode);
        this.applicationRoot = theme.decorate(APPLICATION_TAG, viewer, this.annotationNode);
        this.sessionRoot = theme.decorate(SESSION_TAG, viewer, this.annotationNode);
        this.requestRoot = theme.decorate(REQUEST_TAG, viewer, this.annotationNode);
        this.tenantRoot = theme.decorate(TENANT_TAG, viewer, this.annotationNode);
        this.rendererTypes = new HashMap();
        this.rendererTypes.put("user", this.userRoot);
        this.rendererTypes.put("application", this.applicationRoot);
        this.rendererTypes.put("session", this.sessionRoot);
        this.rendererTypes.put("request", this.requestRoot);
        this.rendererTypes.put("tenant", this.tenantRoot);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadAnnotation impl = (AbstractFilterByThreadAnnotation)element;
        this.annotationNode.setText(Utils.getRenderText(AnnotationSelectionContextCreator.toString(impl.getKey(), impl.getAnnotations()), 4, 15));
        return this.rendererTypes.get(impl.getKey());
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadAnnotation impl = (AbstractFilterByThreadAnnotation)element;
        return Utils.getToolTipText(AnnotationSelectionContextCreator.toString(impl.getKey(), impl.getAnnotations()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{ThreadElements.FilterByThreadAnnotation.class, ThreadElements.FilterByBlockedThreadAnnotation.class, ThreadElements.FilterByBlockingThreadAnnotation.class};
    }

    private static String[] toString(String key, String[] annotations) {
        String[] result = new String[annotations.length];
        ThreadAnnotationContext context = new ThreadAnnotationContext(key, "");
        for (int i = 0; i < result.length; ++i) {
            result[i] = annotations[i].length() == 0 ? context.getDefaultNoValueText() : annotations[i];
        }
        return result;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        AbstractFilterByThreadAnnotation impl = (AbstractFilterByThreadAnnotation)element;
        return Utils.getRenderText(AnnotationSelectionContextCreator.toString(impl.getKey(), impl.getAnnotations()), 4, 15);
    }
}

