/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.UseClassesAsCalledRoots;
import com.sap.jvm.profiling.snapshot.elements.UseClassesAsCallingRoots;
import com.sap.jvm.profiling.snapshot.elements.util.ClassesWithInlineBase;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class ClassSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedClasses";
    private static final int MAX_RENDER_CLASSES = 4;
    private static final int MAX_TOOL_TIP_CLASSES = 20;
    private TextNode classesNode;
    private RendererNode root;

    public ClassSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.classesNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.classesNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        ClassesWithInlineBase impl = (ClassesWithInlineBase)element;
        this.classesNode.setText(Utils.getRenderText(Utils.toString(impl.getClasses()), 4, 100));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        ClassesWithInlineBase impl = (ClassesWithInlineBase)element;
        return Utils.getToolTipText(Utils.toString(impl.getClasses()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{UseClassesAsCalledRoots.class, UseClassesAsCallingRoots.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        ClassesWithInlineBase impl = (ClassesWithInlineBase)element;
        return Utils.getRenderText(Utils.toString(impl.getClasses()), 4, 100);
    }
}

