/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.ElementWithFilterEntities;
import com.sap.jvm.profiling.snapshot.elements.UseCalledFilterCombinerBottomSelfAsRoots;
import com.sap.jvm.profiling.snapshot.elements.UseCalledFilterCombinerBottomTotalAsRoots;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class EntitySelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedFilterEntities";
    private static final int MAX_RENDER_ENTITIES = 3;
    private static final int MAX_ENTITY_NAME = 20;
    private static final int MAX_TOOL_TIP_ENTITIES = 20;
    private TextNode entityNode;
    private RendererNode root;

    public EntitySelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.entityNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.entityNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        ElementWithFilterEntities impl = (ElementWithFilterEntities)element;
        this.entityNode.setText(Utils.getRenderText(Utils.toString(impl.getEntities()), 3, 20));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        ElementWithFilterEntities impl = (ElementWithFilterEntities)element;
        return Utils.getToolTipText(Utils.toString(impl.getEntities()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{UseCalledFilterCombinerBottomTotalAsRoots.class, UseCalledFilterCombinerBottomSelfAsRoots.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        ElementWithFilterEntities impl = (ElementWithFilterEntities)element;
        return Utils.getRenderText(Utils.toString(impl.getEntities()), 3, 20);
    }
}

