/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByFileId;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class FileIdSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedFileIds";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 20;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode idNode;
    private RendererNode root;

    public FileIdSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.idNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.idNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByFileId impl = (FilterByFileId)element;
        String[] idStrings = this.toString(impl, 3);
        this.idNode.setText(Utils.getRenderText(idStrings, 3, 20));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByFileId impl = (FilterByFileId)element;
        String[] idStrings = this.toString(impl, 20);
        return Utils.getToolTipText(idStrings, 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByFileId.class};
    }

    private String[] toString(FilterByFileId filter, int max) {
        long[] dispIds = filter.getDisplayIds();
        long[] fds = filter.getFds();
        int size = Math.min(fds.length, max);
        String[] idStrings = new String[size];
        for (int i = 0; i < size; ++i) {
            idStrings[i] = dispIds[i] + " (FD " + fds[i] + ")";
        }
        return idStrings;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByFileId impl = (FilterByFileId)element;
        String[] idStrings = this.toString(impl, 3);
        return Utils.getRenderText(idStrings, 3, 20);
    }
}

