/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.ShiftByCalledFilterEntityTotalPath;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntity;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public class FilterEntityPathSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedFilterEntityPaths";
    private static final int MAX_RENDER_PATHS = 3;
    private static final int MAX_RENDER_ENTITIES_PER_PATH = 2;
    private static final int MAX_TOOL_TIP_PATHS = 10;
    private static final int MAX_TOOL_TIP_ENTITIES_PER_PATH = 5;
    private TextNode pathsNode;
    private RendererNode root;

    public FilterEntityPathSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.pathsNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.pathsNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        this.pathsNode.setText(this.createRednererNodeText(element, session));
        return this.root;
    }

    private String createRednererNodeText(ResourceNameElement element, ProfilingSession session) {
        ShiftByCalledFilterEntityTotalPath impl = (ShiftByCalledFilterEntityTotalPath)element;
        FilterEntity[][] paths = impl.getPaths();
        int nrOfPaths = Math.min(paths.length, 3);
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < nrOfPaths; ++i) {
            FilterEntity[] path;
            int nrOfEntities;
            if (i > 0) {
                text.append(',');
            }
            if ((nrOfEntities = Math.min((path = paths[i]).length, 2)) < path.length) {
                text.append("..->");
            }
            for (int j = 0; j < nrOfEntities; ++j) {
                FilterEntity entity;
                MethodFilter filter;
                if (j > 0) {
                    text.append("->");
                }
                if ((filter = (entity = path[j + path.length - nrOfEntities]).getFilter()) == null) {
                    text.append(I18n._s((String)"<none>"));
                    continue;
                }
                text.append(filter.getName());
            }
        }
        if (nrOfPaths < paths.length) {
            text.append(",..");
        }
        return text.toString();
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        ShiftByCalledFilterEntityTotalPath impl = (ShiftByCalledFilterEntityTotalPath)element;
        FilterEntity[][] paths = impl.getPaths();
        int nrOfPaths = Math.min(paths.length, 10);
        StringBuilder text = new StringBuilder();
        String indent = "  ";
        for (int i = 0; i < nrOfPaths; ++i) {
            FilterEntity[] path;
            int nrOfEntities;
            if (i > 0) {
                text.append('\n');
            }
            if ((nrOfEntities = Math.min((path = paths[i]).length, 5)) < path.length) {
                text.append(indent + "...\n");
            }
            for (int j = 0; j < nrOfEntities; ++j) {
                for (int k = 0; k < j + 2; ++k) {
                    text.append(indent);
                }
                FilterEntity entity = path[j + path.length - nrOfEntities];
                MethodFilter filter = entity.getFilter();
                if (filter == null) {
                    text.append(I18n._s((String)"<none>"));
                } else {
                    text.append(filter.getName());
                }
                text.append('\n');
            }
        }
        if (nrOfPaths < paths.length) {
            text.append("\n   ...");
        }
        return text.toString();
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{ShiftByCalledFilterEntityTotalPath.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return this.createRednererNodeText(element, session);
    }
}

