/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByGcEventType;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.util.Set;

public final class GcEventTypeSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedGcEvents";
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode typeNode;
    private RendererNode root;

    public GcEventTypeSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.typeNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.typeNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByGcEventType impl = (FilterByGcEventType)element;
        GcEventType[] types = impl.getEventTypes().toArray(new GcEventType[impl.getEventTypes().size()]);
        if (!impl.isCustom() || types.length == 0) {
            this.typeNode.setText("");
            return this.typeNode;
        }
        String firstName = types[0].getShortDescrDisplay();
        if (types.length == 1) {
            this.typeNode.setText(firstName);
        } else {
            this.typeNode.setText(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"{0} event types ({1}, ...", (Object[])new Object[]{impl.getEventTypes().size(), firstName}));
        }
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByGcEventType impl = (FilterByGcEventType)element;
        String[] idStrings = this.toString(impl, 21);
        return I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Event Types: \n{0}", (Object[])new Object[]{Utils.getToolTipText(idStrings, 20)});
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByGcEventType.class};
    }

    private String[] toString(FilterByGcEventType impl, int max) {
        Set<GcEventType> types = impl.getEventTypes();
        int size = Math.min(types.size(), max);
        String[] idStrings = new String[size];
        int i = 0;
        for (GcEventType type : types) {
            idStrings[i++] = type.getShortDescrDisplay();
        }
        return idStrings;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByGcEventType impl = (FilterByGcEventType)element;
        return I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"{0} event types", (Object[])new Object[]{impl.getEventTypes().size()});
    }
}

