/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByGcId;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class GcIdSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedGcIds";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 20;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode idNode;
    private RendererNode root;

    public GcIdSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.idNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.idNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByGcId impl = (FilterByGcId)element;
        String[] idStrings = this.toString(impl, 4);
        this.idNode.setText(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"GCs: {0}", (Object[])new Object[]{Utils.getRenderText(idStrings, 3, 20)}));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByGcId impl = (FilterByGcId)element;
        String[] idStrings = this.toString(impl, 21);
        return Utils.getToolTipText(idStrings, 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByGcId.class};
    }

    private String[] toString(FilterByGcId impl, int max) {
        long[] ids = impl.getIds();
        int size = Math.min(ids.length, max);
        String[] idStrings = new String[size];
        for (int i = 0; i < size; ++i) {
            idStrings[i] = Long.toString(ids[i]);
        }
        return idStrings;
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByGcId impl = (FilterByGcId)element;
        String[] idStrings = this.toString(impl, 4);
        return I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"GCs: {0}", (Object[])new Object[]{Utils.getRenderText(idStrings, 3, 20)});
    }
}

