/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.presentation.typed.gc.Attribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcTimeSeriesMetaData;
import com.sap.jvm.profiling.presentation.typed.gc.elements.SelectTimeSeriesElement;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import java.util.ArrayList;
import java.util.List;

public final class GcTimeSeriesSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedGcAttributes";
    private static final int MAX_RENDER_NAMES = 3;
    private static final int MAX_NAME_LENGTH = 20;
    private static final int MAX_TOOL_TIP_NAMES = 20;
    private TextNode attributesNode;
    private RendererNode root;

    public GcTimeSeriesSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.attributesNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.attributesNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        SelectTimeSeriesElement impl = (SelectTimeSeriesElement)element;
        String[] attributeStrings = this.toString(impl, session, 4);
        this.attributesNode.setText(Utils.getRenderText(attributeStrings, 3, 20));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        SelectTimeSeriesElement impl = (SelectTimeSeriesElement)element;
        String[] attributeStrings = this.toString(impl, session, 21);
        return Utils.getToolTipText(attributeStrings, 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{SelectTimeSeriesElement.class};
    }

    private String[] toString(SelectTimeSeriesElement impl, ProfilingSession session, int max) {
        List<Integer> timeSeries = impl.getSelection().getTimeSeriesFlat();
        int size = Math.min(timeSeries.size(), max);
        ArrayList<String> idStrings = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Attribute<?> attribute = GcTimeSeriesMetaData.ATTRIBUTE_FOR_TIMESERIES[timeSeries.get(i)];
            if (attribute == null) continue;
            idStrings.add(attribute.getShortDescription(session));
        }
        return idStrings.toArray(new String[idStrings.size()]);
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        SelectTimeSeriesElement impl = (SelectTimeSeriesElement)element;
        String[] idStrings = this.toString(impl, session, 4);
        return Utils.getRenderText(idStrings, 3, 20);
    }
}

