/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.InlineByFilter;
import com.sap.jvm.profiling.snapshot.elements.InlineByPredefinedFilter;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class InlineContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.inlineByFilter";
    private static final int MAX_RENDER_FILTERS = 3;
    private static final int MAX_FILTER_NAME = 20;
    private static final int MAX_TOOL_TIP_FILTERS = 20;
    private TextNode filterNode;
    private RendererNode root;

    public InlineContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.filterNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.filterNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        if (element instanceof InlineByFilter) {
            InlineByFilter impl = (InlineByFilter)element;
            this.filterNode.setText(Utils.getRenderText(Utils.toString(impl.getFilters()), 3, 20));
        } else if (element instanceof InlineByPredefinedFilter) {
            InlineByPredefinedFilter impl = (InlineByPredefinedFilter)element;
            if (impl.getShowCreationContext()) {
                this.filterNode.setText(Utils.getRenderText(Utils.toString(impl.getFilters()), 3, 20));
            } else {
                this.filterNode.setText("");
                return this.filterNode;
            }
        }
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        if (element instanceof InlineByFilter) {
            InlineByFilter impl = (InlineByFilter)element;
            return Utils.getToolTipText(Utils.toString(impl.getFilters()), 20);
        }
        if (element instanceof InlineByPredefinedFilter) {
            InlineByPredefinedFilter impl = (InlineByPredefinedFilter)element;
            return "Predefined: " + Utils.getToolTipText(Utils.toString(impl.getFilters()), 20);
        }
        assert (false);
        return "";
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{InlineByFilter.class, InlineByPredefinedFilter.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return null;
    }
}

