/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.presentation.impl.resource.context.Utils;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByInvocationIds;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;

public final class InvocationIdSelectionContexCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedInvocationIds";
    private static final int MAX_RENDER_IDS = 3;
    private static final int MAX_ID_NAME = 25;
    private static final int MAX_TOOL_TIP_IDS = 20;
    private TextNode idNode;
    private RendererNode root;

    public InvocationIdSelectionContexCreator(ModelViewer viewer, RendererTheme theme) {
        this.idNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.idNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        FilterByInvocationIds impl = (FilterByInvocationIds)element;
        this.idNode.setText(Utils.getRenderText(Utils.toString(impl.getInvocationIds()), 3, 25));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        FilterByInvocationIds impl = (FilterByInvocationIds)element;
        return Utils.getToolTipText(Utils.toString(impl.getInvocationIds()), 20);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterByInvocationIds.class};
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        FilterByInvocationIds impl = (FilterByInvocationIds)element;
        return Utils.getRenderText(Utils.toString(impl.getInvocationIds()), 3, 25);
    }
}

