/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.impl.resource.context;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.impl.typed.alloc.AbstractArrayLengthHistogramProvider;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocatedArraysByRange;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import com.sap.jvm.util.pair.IntPair;
import java.util.ArrayList;
import java.util.Arrays;

public final class LengthRangeSelectionContextCreator
implements ElementContextCreator {
    private static final String TAG = "context.selectedLengthRanges";
    private static final int MAX_RENDER_RANGES = 3;
    private static final int MAX_TOOL_TIP_LENGTHS = 20;
    private TextNode rangesNode;
    private RendererNode root;

    public LengthRangeSelectionContextCreator(ModelViewer viewer, RendererTheme theme) {
        this.rangesNode = viewer.newTextNode(null);
        this.root = theme.decorate(TAG, viewer, this.rangesNode);
    }

    @Override
    public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
        this.rangesNode.setText(this.getRenderText((FilterAllocatedArraysByRange)element));
        return this.root;
    }

    @Override
    public String createToolTip(ResourceNameElement element, ProfilingSession session) {
        return this.getToolTipText((FilterAllocatedArraysByRange)element);
    }

    @Override
    public Class<?>[] getSupportedElements() {
        return new Class[]{FilterAllocatedArraysByRange.class};
    }

    private String getRenderText(FilterAllocatedArraysByRange base) {
        IntPair[] ranges = this.getSortedGroups(base);
        int nrOfGroups = Math.min(3, ranges.length);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nrOfGroups; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(AbstractArrayLengthHistogramProvider.getShortRange(ranges[i]));
        }
        if (nrOfGroups < ranges.length) {
            result.append(",...");
        }
        return result.toString();
    }

    private String getToolTipText(FilterAllocatedArraysByRange base) {
        IntPair[] ranges = this.getSortedGroups(base);
        int nrOfGroups = Math.min(20, ranges.length);
        StringBuilder result = new StringBuilder(I18n._s((String)"Includes arrays of the following length:"));
        for (int i = 0; i < nrOfGroups; ++i) {
            result.append("\n    ");
            result.append(AbstractArrayLengthHistogramProvider.getToolTipForRange(ranges[i]));
        }
        if (nrOfGroups < ranges.length) {
            result.append("\n   ...");
        }
        return result.toString();
    }

    private IntPair[] getSortedGroups(FilterAllocatedArraysByRange base) {
        Object[] ranges = base.getRanges();
        Arrays.sort(ranges);
        ArrayList<Object> result = new ArrayList<Object>();
        Object lastRange = null;
        for (Object range : ranges) {
            if (lastRange != null && lastRange.getSecond() == range.getFirst()) {
                lastRange = new IntPair(lastRange.getFirst(), range.getSecond());
                continue;
            }
            if (lastRange != null) {
                result.add(lastRange);
            }
            lastRange = range;
        }
        result.add(lastRange);
        return result.toArray(new IntPair[result.size()]);
    }

    @Override
    public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
        return this.getRenderText((FilterAllocatedArraysByRange)element);
    }
}

